/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class SearchGroupsResolver
implements LdapSession.GroupsResolver {
    private final String baseDn;
    private final String filter;
    private final String userAttribute;
    private final LdapSearchScope scope;
    private final boolean ignoreReferralErrors;

    SearchGroupsResolver(RealmConfig config) {
        this.baseDn = (String)config.getSetting(SearchGroupsResolverSettings.BASE_DN, () -> {
            throw new IllegalArgumentException("base_dn must be specified");
        });
        this.filter = (String)config.getSetting(SearchGroupsResolverSettings.FILTER);
        this.userAttribute = (String)config.getSetting(SearchGroupsResolverSettings.USER_ATTRIBUTE);
        this.scope = (LdapSearchScope)config.getSetting(SearchGroupsResolverSettings.SCOPE);
        this.ignoreReferralErrors = (Boolean)config.getSetting(SessionFactorySettings.IGNORE_REFERRAL_ERRORS_SETTING);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        this.getUserId(userDn, attributes, connection, timeout, (ActionListener<String>)ActionListener.wrap(userId -> {
            if (userId == null) {
                listener.onResponse(List.of());
            } else {
                try {
                    Filter userFilter = LdapUtils.createFilter(this.filter, userId);
                    LdapUtils.search(connection, this.baseDn, this.scope.scope(), userFilter, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> listener.onResponse(results.stream().map(r -> r.getDN()).toList()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), "1.1");
                }
                catch (LDAPException e) {
                    listener.onFailure((Exception)((Object)e));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public String[] attributes() {
        if (Strings.hasLength((String)this.userAttribute)) {
            return new String[]{this.userAttribute};
        }
        return null;
    }

    private void getUserId(String dn, Collection<Attribute> attributes, LDAPInterface connection, TimeValue timeout, ActionListener<String> listener) {
        if (Strings.isNullOrEmpty((String)this.userAttribute) || this.userAttribute.equals("dn")) {
            listener.onResponse((Object)dn);
        } else if (attributes != null) {
            String value = attributes.stream().filter(attribute -> attribute.getName().equals(this.userAttribute)).map(Attribute::getValue).findFirst().orElse(null);
            listener.onResponse((Object)value);
        } else {
            this.readUserAttribute(connection, dn, timeout, listener);
        }
    }

    void readUserAttribute(LDAPInterface connection, String userDn, TimeValue timeout, ActionListener<String> listener) {
        LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null || !entry.hasAttribute(this.userAttribute)) {
                listener.onResponse(null);
            } else {
                listener.onResponse((Object)entry.getAttributeValue(this.userAttribute));
            }
        }, arg_0 -> listener.onFailure(arg_0)), this.userAttribute);
    }
}

