/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public final class BytesKey {
    final byte[] bytes;
    private final int hashCode;

    public BytesKey(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = StringHelper.murmurhash3_x86_32((byte[])bytes, (int)0, (int)bytes.length, (int)StringHelper.GOOD_FAST_HASH_SEED);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof BytesKey)) {
            return false;
        }
        BytesKey otherBytes = (BytesKey)other;
        return Arrays.equals(otherBytes.bytes, this.bytes);
    }

    public String toString() {
        return new BytesRef(this.bytes).toString();
    }
}

