/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.SSLExceptionHelper;

public final class SecurityTransportExceptionHandler
implements BiConsumer<TcpChannel, Exception> {
    private final Lifecycle lifecycle;
    private final Logger logger;
    private final BiConsumer<TcpChannel, Exception> fallback;

    public SecurityTransportExceptionHandler(Logger logger, Lifecycle lifecycle, BiConsumer<TcpChannel, Exception> fallback) {
        this.lifecycle = lifecycle;
        this.logger = logger;
        this.fallback = fallback;
    }

    @Override
    public void accept(TcpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isNotSslRecordException((Throwable)e)) {
            this.logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException((Throwable)e)) {
            this.logger.debug("connection {} closed during handshake", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isInsufficientBufferRemainingException((Throwable)e)) {
            this.logger.debug("connection {} closed abruptly", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException((Throwable)e)) {
            this.logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else {
            this.fallback.accept(channel, e);
        }
    }
}

