/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.AsyncTaskMaintenanceService;

public class AsyncResultsIndexPlugin
extends Plugin
implements SystemIndexPlugin {
    protected final Settings settings;

    public AsyncResultsIndexPlugin(Settings settings) {
        this.settings = settings;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings unused) {
        return List.of(AsyncTaskIndexService.getSystemIndexDescriptor());
    }

    public String getFeatureName() {
        return "async_search";
    }

    public String getFeatureDescription() {
        return "Manages results of async searches";
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ArrayList<AsyncTaskMaintenanceService> components = new ArrayList<AsyncTaskMaintenanceService>();
        if (DiscoveryNode.canContainData((Settings)services.environment().settings())) {
            AsyncTaskMaintenanceService maintenanceService = new AsyncTaskMaintenanceService(services.clusterService(), services.projectResolver(), services.nodeEnvironment().nodeId(), this.settings, services.threadPool(), (Client)new OriginSettingClient(services.client(), "async_search"));
            components.add(maintenanceService);
        }
        return components;
    }
}

