/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.tsid;

import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPoint;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;
import org.elasticsearch.xpack.oteldata.otlp.tsid.AttributeListTsidFunnel;

public class DataPointTsidFunnel
implements TsidBuilder.TsidFunnel<DataPoint> {
    private static final int EXTRA_DIMENSIONS_SIZE = 2;
    private final BufferedByteStringAccessor byteStringAccessor;

    private DataPointTsidFunnel(BufferedByteStringAccessor byteStringAccessor) {
        this.byteStringAccessor = byteStringAccessor;
    }

    public static TsidBuilder forDataPoint(BufferedByteStringAccessor byteStringAccessor, DataPoint dataPoint, int scopeTsidBuilderSize) {
        TsidBuilder tsidBuilder = new TsidBuilder(dataPoint.getAttributes().size() + scopeTsidBuilderSize + 2);
        new DataPointTsidFunnel(byteStringAccessor).add(dataPoint, tsidBuilder);
        return tsidBuilder;
    }

    public void add(DataPoint dataPoint, TsidBuilder tsidBuilder) {
        tsidBuilder.add(dataPoint.getAttributes(), (TsidBuilder.TsidFunnel)AttributeListTsidFunnel.get(this.byteStringAccessor, "attributes."));
        tsidBuilder.addStringDimension("unit", dataPoint.getUnit());
    }
}

