/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.tsid;

import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.util.List;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.xpack.oteldata.otlp.docbuilder.MetricDocumentBuilder;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;

class AttributeListTsidFunnel
implements TsidBuilder.TsidFunnel<List<KeyValue>> {
    private final String prefix;
    private final BufferedByteStringAccessor byteStringAccessor;

    private AttributeListTsidFunnel(BufferedByteStringAccessor byteStringAccessor, String prefix) {
        this.prefix = prefix;
        this.byteStringAccessor = byteStringAccessor;
    }

    static AttributeListTsidFunnel get(BufferedByteStringAccessor byteStringAccessor, String prefix) {
        return new AttributeListTsidFunnel(byteStringAccessor, prefix);
    }

    public void add(List<KeyValue> attributesList, TsidBuilder tsidBuilder) {
        for (int i = 0; i < attributesList.size(); ++i) {
            KeyValue keyValue = attributesList.get(i);
            String attributeKey = keyValue.getKey();
            if (MetricDocumentBuilder.isIgnoredAttribute(attributeKey)) continue;
            this.hashValue(tsidBuilder, this.prefix + attributeKey, keyValue.getValue());
        }
    }

    private void hashValue(TsidBuilder tsidBuilder, String key, AnyValue value) {
        switch (value.getValueCase()) {
            case STRING_VALUE: {
                this.byteStringAccessor.addStringDimension(tsidBuilder, key, value.getStringValueBytes());
                break;
            }
            case BOOL_VALUE: {
                tsidBuilder.addBooleanDimension(key, value.getBoolValue());
                break;
            }
            case DOUBLE_VALUE: {
                tsidBuilder.addDoubleDimension(key, value.getDoubleValue());
                break;
            }
            case INT_VALUE: {
                tsidBuilder.addLongDimension(key, value.getIntValue());
                break;
            }
            case KVLIST_VALUE: {
                tsidBuilder.add(value.getKvlistValue().getValuesList(), (TsidBuilder.TsidFunnel)AttributeListTsidFunnel.get(this.byteStringAccessor, key + "."));
                break;
            }
            case ARRAY_VALUE: {
                List<AnyValue> valuesList = value.getArrayValue().getValuesList();
                for (int i = 0; i < valuesList.size(); ++i) {
                    this.hashValue(tsidBuilder, key, valuesList.get(i));
                }
                break;
            }
        }
    }
}

