/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.oteldata.OTelIndexTemplateRegistry;
import org.elasticsearch.xpack.oteldata.otlp.OTLPMetricsRestAction;
import org.elasticsearch.xpack.oteldata.otlp.OTLPMetricsTransportAction;

public class OTelPlugin
extends Plugin
implements ActionPlugin {
    static final Setting<Boolean> OTEL_DATA_REGISTRY_ENABLED = Setting.boolSetting((String)"xpack.otel_data.registry.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final Logger logger = LogManager.getLogger(OTelPlugin.class);
    private final SetOnce<OTelIndexTemplateRegistry> registry = new SetOnce();
    private final boolean enabled;

    public OTelPlugin(Settings settings) {
        this.enabled = (Boolean)XPackSettings.OTEL_DATA_ENABLED.get(settings);
    }

    public Collection<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new OTLPMetricsRestAction());
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        logger.info("OTel ingest plugin is {}", (Object)(this.enabled ? "enabled" : "disabled"));
        Settings settings = services.environment().settings();
        ClusterService clusterService = services.clusterService();
        this.registry.set((Object)new OTelIndexTemplateRegistry(settings, clusterService, services.threadPool(), services.client(), services.xContentRegistry()));
        if (this.enabled) {
            OTelIndexTemplateRegistry registryInstance = (OTelIndexTemplateRegistry)((Object)this.registry.get());
            registryInstance.setEnabled((Boolean)OTEL_DATA_REGISTRY_ENABLED.get(settings));
            registryInstance.initialize();
        }
        return List.of();
    }

    public void close() {
        ((OTelIndexTemplateRegistry)((Object)this.registry.get())).close();
    }

    public List<Setting<?>> getSettings() {
        return List.of(OTEL_DATA_REGISTRY_ENABLED);
    }

    public Collection<ActionPlugin.ActionHandler> getActions() {
        return List.of(new ActionPlugin.ActionHandler(OTLPMetricsTransportAction.TYPE, OTLPMetricsTransportAction.class));
    }
}

