/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.concurrent.Callable;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;

public class Stopwatch {
    private long myStart = System.nanoTime();

    public static <T> TimedResult<T> meassure(Callable<T> task) {
        return Stopwatch.meassure(task, CalendarDateUnit.MILLIS);
    }

    public static <T> TimedResult<T> meassure(Callable<T> task, CalendarDateUnit unit) {
        T result;
        Stopwatch timer = new Stopwatch();
        try {
            result = task.call();
        }
        catch (Exception cause) {
            result = null;
        }
        CalendarDateDuration duration = timer.stop(unit);
        return new TimedResult<T>(result, duration);
    }

    public static CalendarDateDuration meassure(Runnable task) {
        return Stopwatch.meassure(task, CalendarDateUnit.MILLIS);
    }

    public static CalendarDateDuration meassure(Runnable task, CalendarDateUnit unit) {
        Stopwatch timer = new Stopwatch();
        task.run();
        return timer.stop(unit);
    }

    public long countMillis() {
        return this.countNanos() / 1000000L;
    }

    public long countNanos() {
        return System.nanoTime() - this.myStart;
    }

    public boolean isLessThan(CalendarDateDuration duration) {
        return this.isLessThanNanos(duration.toDurationInNanos());
    }

    public boolean isLessThanMillis(long millis) {
        return this.isLessThanNanos(millis * 1000000L);
    }

    public boolean isLessThanNanos(long nanos) {
        return this.countNanos() < nanos;
    }

    public boolean isMoreThan(CalendarDateDuration duration) {
        return this.isMoreThanNanos(duration.toDurationInNanos());
    }

    public boolean isMoreThanMillis(long millis) {
        return this.isMoreThanNanos(millis * 1000000L);
    }

    public boolean isMoreThanNanos(long nanos) {
        return this.countNanos() > nanos;
    }

    public void reset() {
        this.myStart = System.nanoTime();
    }

    public long reset(CalendarDateUnit unit) {
        long now = System.nanoTime();
        long nanos = now - this.myStart;
        this.myStart = now;
        return nanos / unit.toDurationInNanos();
    }

    public CalendarDateDuration restart() {
        long nanos = this.countNanos();
        this.reset();
        return CalendarDateDuration.of(nanos);
    }

    public CalendarDateDuration restart(CalendarDateUnit unit) {
        return this.restart().convertTo(unit);
    }

    public CalendarDateDuration stop() {
        return CalendarDateDuration.of(this.countNanos());
    }

    public CalendarDateDuration stop(CalendarDateUnit unit) {
        return this.stop().convertTo(unit);
    }

    public static final class TimedResult<T> {
        public final CalendarDateDuration duration;
        public final T result;

        public TimedResult(T result, CalendarDateDuration duration) {
            this.result = result;
            this.duration = duration;
        }
    }
}

