/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;

public interface Mutate2D
extends Structure2D,
Mutate1D {
    @Override
    default public void set(long index, Comparable<?> addend) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
    }

    @Override
    default public void set(long index, double addend) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
    }

    @Override
    default public void set(long index, float addend) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
    }

    public void set(long var1, long var3, Comparable<?> var5);

    public void set(long var1, long var3, double var5);

    default public void set(long row, long col, float value) {
        this.set(row, col, (double)value);
    }

    public static interface Receiver<N extends Comparable<N>>
    extends Mutate2D,
    Fillable<N>,
    Consumer<Access2D<?>> {
        @Override
        default public void accept(Access2D<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            supplied.loopAll((long r, long c) -> this.set(r, c, (Comparable<?>)supplied.get(r, c)));
        }

        default public boolean isAcceptable(Structure2D supplier) {
            return this.countRows() >= supplier.countRows() && this.countColumns() >= supplier.countColumns();
        }
    }

    public static interface ModifiableReceiver<N extends Comparable<N>>
    extends Modifiable<N>,
    Receiver<N>,
    Exchangeable,
    Access2D<N> {
        public void modifyAny(Transformation2D<N> var1);
    }

    public static interface Modifiable<N extends Comparable<N>>
    extends Structure2D,
    Mutate1D.Modifiable<N> {
        @Override
        default public void add(long index, Comparable<?> addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, double addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, float addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        public void add(long var1, long var3, Comparable<?> var5);

        public void add(long var1, long var3, double var5);

        default public void add(long row, long col, float addend) {
            this.add(row, col, (double)addend);
        }

        default public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.loopColumn(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyColumn(long col, UnaryFunction<N> modifier) {
            this.modifyColumn(0L, col, modifier);
        }

        default public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.loopDiagonal(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyDiagonal(UnaryFunction<N> modifier) {
            this.modifyDiagonal(0L, 0L, modifier);
        }

        default public void modifyMatchingInColumns(Access1D<N> left, BinaryFunction<N> function) {
            left.loopAll((long r) -> this.modifyRow(r, function.first(left.get(r))));
        }

        default public void modifyMatchingInColumns(BinaryFunction<N> function, Access1D<N> right) {
            right.loopAll((long r) -> this.modifyRow(r, function.second(right.get(r))));
        }

        default public void modifyMatchingInRows(Access1D<N> left, BinaryFunction<N> function) {
            left.loopAll((long c) -> this.modifyColumn(c, function.first(left.get(c))));
        }

        default public void modifyMatchingInRows(BinaryFunction<N> function, Access1D<N> right) {
            right.loopAll((long c) -> this.modifyColumn(c, function.second(right.get(c))));
        }

        public void modifyOne(long var1, long var3, UnaryFunction<N> var5);

        @Override
        default public void modifyOne(long index, UnaryFunction<N> modifier) {
            long structure = this.countRows();
            this.modifyOne(Structure2D.row(index, structure), Structure2D.column(index, structure), modifier);
        }

        default public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.loopRow(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyRow(long row, UnaryFunction<N> modifier) {
            this.modifyRow(row, 0L, modifier);
        }
    }

    public static interface Mixable<N extends Comparable<N>>
    extends Structure2D,
    Mutate1D.Mixable<N> {
        @Override
        default public double mix(long index, BinaryFunction<N> mixer, double addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, (N)addend);
        }

        @Override
        default public N mix(long index, BinaryFunction<N> mixer, N addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, addend);
        }

        public double mix(long var1, long var3, BinaryFunction<N> var5, double var6);

        public N mix(long var1, long var3, BinaryFunction<N> var5, N var6);
    }

    public static interface Fillable<N extends Comparable<N>>
    extends Structure2D,
    Mutate1D.Fillable<N> {
        default public void fillColumn(long col, Access1D<N> values) {
            this.fillColumn(0L, col, (N)values);
        }

        default public void fillColumn(long row, long col, Access1D<N> values) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, values.get(r - row)));
        }

        default public void fillColumn(long row, long col, N value) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillColumn(long col, N value) {
            this.fillColumn(0L, col, value);
        }

        default public void fillColumn(long col, NullaryFunction<?> supplier) {
            this.fillColumn(0L, col, supplier);
        }

        default public void fillDiagonal(Access1D<N> values) {
            this.fillDiagonal(0L, 0L, (N)values);
        }

        default public void fillDiagonal(long row, long col, Access1D<N> values) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, values.get(r - row)));
        }

        default public void fillDiagonal(long row, long col, N value) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillDiagonal(N value) {
            this.fillDiagonal(0L, 0L, value);
        }

        default public void fillDiagonal(NullaryFunction<?> supplier) {
            this.fillDiagonal(0L, 0L, supplier);
        }

        @Override
        default public void fillOne(long index, Access1D<?> values, long valueIndex) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), values, valueIndex);
        }

        public void fillOne(long var1, long var3, Access1D<?> var5, long var6);

        public void fillOne(long var1, long var3, N var5);

        public void fillOne(long var1, long var3, NullaryFunction<?> var5);

        @Override
        default public void fillOne(long index, N value) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
        }

        @Override
        default public void fillOne(long index, NullaryFunction<?> supplier) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), supplier);
        }

        default public void fillRow(long row, Access1D<N> values) {
            this.fillRow(row, 0L, (N)values);
        }

        default public void fillRow(long row, long col, Access1D<N> values) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, values.get(c - col)));
        }

        default public void fillRow(long row, long col, N value) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillRow(long row, long col, NullaryFunction<?> supplier) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillRow(long row, N value) {
            this.fillRow(row, 0L, value);
        }

        default public void fillRow(long row, NullaryFunction<?> supplier) {
            this.fillRow(row, 0L, supplier);
        }
    }

    public static interface Exchangeable
    extends Structure2D {
        public void exchangeColumns(long var1, long var3);

        public void exchangeRows(long var1, long var3);
    }
}

