/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.function;

import java.util.Map;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.CoordinationSet;
import org.ojalgo.series.function.SeriesExtrapolator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;

public abstract class SeriesForecaster
extends SeriesExtrapolator<CalendarDate> {
    private final CalendarDate myLastKey;
    private final CalendarDateUnit myResolution;

    private SeriesForecaster(BasicSeries<CalendarDate, ? extends Number> data) {
        super(data);
        this.myLastKey = null;
        this.myResolution = null;
    }

    private SeriesForecaster(Map<String, ? extends BasicSeries<CalendarDate, ? extends Comparable<?>>> data) {
        super(data);
        this.myLastKey = null;
        this.myResolution = null;
    }

    protected SeriesForecaster(CalendarDateSeries<? extends Comparable<?>> data) {
        super(data);
        this.myLastKey = (CalendarDate)data.lastKey();
        this.myResolution = data.getResolution();
    }

    protected SeriesForecaster(CoordinationSet<? extends Comparable<?>> coordinatedHistoricalData) {
        super(coordinatedHistoricalData);
        this.myLastKey = coordinatedHistoricalData.getEarliestLastKey();
        this.myResolution = coordinatedHistoricalData.getResolution();
    }

    public Map<String, Access1D<?>> invoke(CalendarDate ... key) {
        CalendarDate tmpLastKey = this.getLastKey();
        CalendarDateUnit tmpResolution = this.getResolution();
        CalendarDateDuration[] tmpHorizon = new CalendarDateDuration[key.length];
        for (int h = 0; h < tmpHorizon.length; ++h) {
            double tmpMeassure = tmpResolution.count(tmpLastKey.millis, key[h].millis);
            tmpHorizon[h] = new CalendarDateDuration(tmpMeassure, tmpResolution);
        }
        return this.invoke(tmpHorizon);
    }

    public abstract Map<String, Access1D<?>> invoke(CalendarDateDuration ... var1);

    protected final CalendarDate getLastKey() {
        return this.myLastKey;
    }

    protected final CalendarDateUnit getResolution() {
        return this.myResolution;
    }
}

