/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.random.AbstractDiscrete;

public class Poisson
extends AbstractDiscrete {
    private final double myLambda;

    public static Poisson of(double lambda) {
        return new Poisson(lambda);
    }

    public Poisson() {
        this(PrimitiveMath.ONE);
    }

    public Poisson(double lambda) {
        this.myLambda = lambda;
    }

    @Override
    public double getExpected() {
        return this.myLambda;
    }

    @Override
    public double getProbability(int value) {
        return PrimitiveMath.EXP.invoke(-this.myLambda) * PrimitiveMath.POW.invoke(this.myLambda, (double)value) / MissingMath.factorial(value);
    }

    @Override
    public double getVariance() {
        return this.myLambda;
    }

    @Override
    protected double generate() {
        int retVal = -1;
        for (double tmpVal = PrimitiveMath.ZERO; tmpVal <= PrimitiveMath.ONE; tmpVal -= PrimitiveMath.LOG.invoke(this.random().nextDouble()) / this.myLambda) {
            ++retVal;
        }
        return retVal;
    }
}

