/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

final class QPESolver
extends ConstrainedSolver {
    private boolean myFeasible = false;
    private final Primitive64Store myIterationX = (Primitive64Store)Primitive64Store.FACTORY.make((long)this.countVariables(), 1L);

    QPESolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    private boolean isFeasible() {
        boolean retVal = true;
        PhysicalStore<Double> tmpSE = this.getSlackE();
        int i = 0;
        while (retVal && (long)i < tmpSE.countRows()) {
            if (!GenericSolver.ACCURACY.isZero(tmpSE.doubleValue(i))) {
                retVal = false;
            }
            ++i;
        }
        return retVal;
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        boolean ok = super.initialise(kickStarter);
        if (kickStarter != null && kickStarter.getState().isFeasible()) {
            this.getSolutionX().fillMatching(kickStarter);
            this.myFeasible = this.isFeasible();
            if (!this.myFeasible) {
                this.getSolutionX().fillAll(PrimitiveMath.ZERO);
            } else {
                this.setState(Optimisation.State.FEASIBLE);
            }
        } else {
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
            this.myFeasible = false;
        }
        return ok;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        Primitive64Store tmpXL;
        MatrixStore<Double> tmpInvQAT;
        MatrixStore<MatrixStore<Double>> tmpS;
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA();
        MatrixStore<Double> tmpIterB = this.getIterationB();
        boolean solved = false;
        Primitive64Store tmpIterX = this.myIterationX;
        Primitive64Store tmpIterL = this.getSolutionL();
        if (tmpIterA.countRows() < tmpIterA.countColumns() && (solved = this.isSolvableQ()) && (solved = this.computeGeneral(tmpS = tmpIterA.multiply((Double)((Object)(tmpInvQAT = this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)tmpIterA.transpose())))))))) {
            MatrixStore<Double> tmpInvQC = this.getSolutionQ(tmpIterC, tmpIterX);
            this.getSolutionGeneral(tmpIterA.multiply((Double)((Object)tmpInvQC)).subtract(tmpIterB), tmpIterL);
            this.getSolutionQ(tmpIterC.subtract((Double)((Object)tmpIterA.transpose().multiply(tmpIterL))), tmpIterX);
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (Primitive64Store)Primitive64Store.FACTORY.make((long)(this.countVariables() + this.countIterationConstraints()), 1L)))) {
            tmpIterX.fillMatching((Access1D<?>)((Object)tmpXL.limits(this.countVariables(), 1L)));
            tmpIterL.fillMatching((Access1D<?>)((Object)tmpXL.offsets(this.countVariables(), 0L)));
        }
        if (solved) {
            this.setState(Optimisation.State.OPTIMAL);
            if (this.myFeasible) {
                this.getSolutionX().modifyMatching(PrimitiveMath.ADD, tmpIterX);
            } else {
                this.getSolutionX().fillMatching(tmpIterX);
            }
        } else if (this.myFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
        this.incrementIterationsCount();
    }

    @Override
    int countIterationConstraints() {
        return (int)this.getIterationA().countRows();
    }

    @Override
    MatrixStore<Double> getIterationA() {
        return this.getMatrixAE();
    }

    @Override
    MatrixStore<Double> getIterationB() {
        if (this.myFeasible) {
            return Primitive64Store.FACTORY.makeZero(this.countEqualityConstraints(), 1L);
        }
        return this.getMatrixBE();
    }

    @Override
    MatrixStore<Double> getIterationC() {
        if (this.myFeasible) {
            PhysicalStore<Double> mtrxQ = this.getMatrixQ();
            MatrixStore<Double> mtrxC = this.getMatrixC();
            PhysicalStore<Double> solX = this.getSolutionX();
            return mtrxC.subtract((Double)((Object)mtrxQ.multiply((Double)((Object)solX))));
        }
        return this.getMatrixC();
    }
}

