/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.structure.Access1D;

public abstract class IntermediateSolver
implements Optimisation.Solver {
    private boolean myInPlaceUpdatesOK = true;
    private transient ExpressionsBasedModel.Integration<?> myIntegration = null;
    private final ExpressionsBasedModel myModel;
    private transient Optimisation.Result myResult = null;
    private transient Optimisation.Solver mySolver = null;

    protected IntermediateSolver(ExpressionsBasedModel model) {
        this.myModel = model;
        this.myIntegration = null;
        this.mySolver = null;
    }

    @Override
    public void dispose() {
        this.reset();
        Optimisation.Solver.super.dispose();
    }

    public Variable getVariable(int globalIndex) {
        return this.myModel.getVariable(globalIndex);
    }

    public void reset() {
        this.myResult = null;
        if (this.mySolver != null) {
            this.mySolver.dispose();
            this.mySolver = null;
        }
        this.myIntegration = null;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result candidate) {
        if (this.mySolver == null && ExpressionsBasedModel.PRESOLVERS.size() > 0) {
            this.myModel.presolve();
        }
        if (this.myModel.isInfeasible()) {
            Optimisation.Result solution = candidate != null ? candidate : this.myModel.getVariableValues();
            return new Optimisation.Result(Optimisation.State.INFEASIBLE, solution);
        }
        if (this.myModel.isUnbounded()) {
            if (candidate != null && this.myModel.validate(candidate)) {
                return new Optimisation.Result(Optimisation.State.UNBOUNDED, candidate);
            }
            Optimisation.Result derivedSolution = this.myModel.getVariableValues();
            if (derivedSolution.getState().isFeasible()) {
                return new Optimisation.Result(Optimisation.State.UNBOUNDED, derivedSolution);
            }
        } else if (this.myModel.isFixed()) {
            Optimisation.Result derivedSolution = this.myModel.getVariableValues();
            if (derivedSolution.getState().isFeasible()) {
                return new Optimisation.Result(Optimisation.State.DISTINCT, derivedSolution);
            }
            return new Optimisation.Result(Optimisation.State.INVALID, derivedSolution);
        }
        ExpressionsBasedModel.Integration<?> integration = this.getIntegration();
        Optimisation.Solver solver = this.getSolver();
        Optimisation.Result retVal = candidate != null ? candidate : this.myModel.getVariableValues();
        retVal = integration.toSolverState(retVal, this.myModel);
        retVal = solver.solve(retVal);
        this.myResult = retVal = integration.toModelState(retVal, this.myModel);
        return retVal;
    }

    public String toString() {
        return this.myModel.toString();
    }

    public void update(Variable variable) {
        if (this.myInPlaceUpdatesOK && this.mySolver != null && this.mySolver instanceof UpdatableSolver && variable.isFixed()) {
            double fixedValue;
            UpdatableSolver updatableSolver = (UpdatableSolver)this.mySolver;
            int indexInSolver = this.getIntegration().getIndexInSolver(this.myModel, variable);
            if (updatableSolver.fixVariable(indexInSolver, fixedValue = variable.getValue().doubleValue())) {
                return;
            }
            this.myInPlaceUpdatesOK = false;
        }
        this.mySolver = null;
    }

    public boolean validate(Access1D<BigDecimal> solution, BasicLogger.Printer appender) {
        return this.myModel.validate(solution, appender);
    }

    protected int getIndexInSolver(int globalModelIndex) {
        Variable variable = this.myModel.getVariable(globalModelIndex);
        ExpressionsBasedModel.Integration<?> integration = this.getIntegration();
        return integration.getIndexInSolver(this.myModel, variable);
    }

    protected ExpressionsBasedModel getModel() {
        return this.myModel;
    }

    protected Optimisation.Result getResult() {
        if (this.myResult == null) {
            this.myResult = this.solve();
        }
        return this.myResult;
    }

    protected boolean isSolved() {
        return this.mySolver != null && this.myResult != null;
    }

    protected Optimisation.Solver getSolver() {
        if (this.mySolver == null) {
            this.mySolver = this.getIntegration().build(this.myModel);
        }
        return this.mySolver;
    }

    ExpressionsBasedModel.Integration<?> getIntegration() {
        if (this.myIntegration == null) {
            this.myIntegration = this.myModel.getIntegration();
        }
        return this.myIntegration;
    }
}

