/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.FileFormatEBM;
import org.ojalgo.optimisation.FileFormatMPS;
import org.ojalgo.optimisation.IntermediateSolver;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Presolvers;
import org.ojalgo.optimisation.SpecialOrderedSet;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public final class ExpressionsBasedModel
implements Optimisation.Model {
    private static final List<Integration<?>> INTEGRATIONS = new ArrayList();
    private static final String NEW_LINE = "\n";
    private static final String OBJ_FUNC_AS_CONSTR_KEY = UUID.randomUUID().toString();
    private static final String OBJECTIVE = "Generated/Aggregated Objective";
    private static final String START_END = "############################################\n";
    static final TreeSet<Presolver> PRESOLVERS = new TreeSet();
    public final Optimisation.Options options;
    private final Map<String, Expression> myExpressions = new HashMap<String, Expression>();
    private final Set<Structure1D.IntIndex> myFixedVariables = new HashSet<Structure1D.IntIndex>();
    private transient boolean myInfeasible = false;
    private BigDecimal myObjectiveConstant = BigMath.ZERO;
    private Optimisation.Sense myOptimisationSense = null;
    private final Set<Structure1D.IntIndex> myReferences;
    private boolean myRelaxed;
    private final boolean myShallowCopy;
    private final Set<Structure1D.IntIndex> myTemporary = new HashSet<Structure1D.IntIndex>();
    private final ArrayList<Variable> myVariables = new ArrayList();
    private final VariablesCategorisation myVariablesCategorisation = new VariablesCategorisation();

    @Deprecated
    public static boolean addFallbackSolver(Integration<?> integration) {
        return ExpressionsBasedModel.addIntegration(integration);
    }

    public static boolean addIntegration(Integration<?> integration) {
        return INTEGRATIONS.add(integration);
    }

    @Deprecated
    public static boolean addPreferredSolver(Integration<?> integration) {
        return ExpressionsBasedModel.addIntegration(integration);
    }

    public static boolean addPresolver(Presolver presolver) {
        return PRESOLVERS.add(presolver);
    }

    public static void clearIntegrations() {
        INTEGRATIONS.clear();
    }

    public static void clearPresolvers() {
        PRESOLVERS.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExpressionsBasedModel parse(File file) {
        FileFormat fileFormat = FileFormat.from(file);
        try (FileInputStream input = new FileInputStream(file);){
            ExpressionsBasedModel expressionsBasedModel = ExpressionsBasedModel.parse(input, fileFormat);
            return expressionsBasedModel;
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static ExpressionsBasedModel parse(InputStream input, FileFormat format) {
        switch (format) {
            case MPS: {
                return FileFormatMPS.read(input);
            }
            case EBM: {
                return FileFormatEBM.read(input);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean removeIntegration(Integration<?> integration) {
        return INTEGRATIONS.remove(integration);
    }

    public static boolean removePresolver(Presolver presolver) {
        return PRESOLVERS.remove(presolver);
    }

    public ExpressionsBasedModel() {
        this(new Optimisation.Options());
    }

    public ExpressionsBasedModel(Collection<? extends Variable> variables) {
        this();
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
    }

    public ExpressionsBasedModel(Optimisation.Options optimisationOptions) {
        this.options = optimisationOptions;
        this.myReferences = new HashSet<Structure1D.IntIndex>();
        this.myShallowCopy = false;
        this.myRelaxed = false;
    }

    public ExpressionsBasedModel(Variable ... variables) {
        this();
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
    }

    ExpressionsBasedModel(ExpressionsBasedModel modelToCopy, boolean shallow, boolean prune) {
        this.options = modelToCopy.options;
        this.setOptimisationSense(modelToCopy.getOptimisationSense());
        this.addObjectiveConstant(modelToCopy.getObjectiveConstant());
        for (Variable tmpVar : modelToCopy.getVariables()) {
            this.myVariables.add(tmpVar.clone());
        }
        Set<Structure1D.IntIndex> fixedVariables = modelToCopy.getFixedVariables();
        for (Expression tmpExpr : modelToCopy.getExpressions()) {
            if (shallow) {
                if (prune) {
                    if (!tmpExpr.isObjective() && (!tmpExpr.isConstraint() || tmpExpr.isRedundant() && !tmpExpr.isInfeasible())) continue;
                    this.myExpressions.put(tmpExpr.getName(), tmpExpr.copy(this, false));
                    continue;
                }
                this.myExpressions.put(tmpExpr.getName(), tmpExpr.copy(this, false));
                continue;
            }
            if (prune) {
                if (!tmpExpr.isObjective() && (!tmpExpr.isConstraint() || tmpExpr.isRedundant() && !tmpExpr.isInfeasible())) continue;
                this.myExpressions.put(tmpExpr.getName(), tmpExpr.copy(this, true).compensate(fixedVariables));
                continue;
            }
            this.myExpressions.put(tmpExpr.getName(), tmpExpr.copy(this, true));
        }
        this.myReferences = modelToCopy.getReferences();
        this.myShallowCopy = shallow || modelToCopy.isShallowCopy();
        this.myRelaxed = modelToCopy.isRelaxed();
    }

    public Expression addExpression() {
        return this.addExpression("EXPR" + this.myExpressions.size());
    }

    public Expression addExpression(String name) {
        Expression retVal = new Expression(name, this);
        this.myExpressions.put(name, retVal);
        return retVal;
    }

    public void addSpecialOrderedSet(Collection<Variable> orderedSet, int type, Expression linkedTo) {
        if (type <= 0) {
            throw new ProgrammingError("Invalid SOS type!");
        }
        if (!linkedTo.isConstraint()) {
            throw new ProgrammingError("The linked to expression needs to be a constraint!");
        }
        Structure1D.IntIndex[] sequence = new Structure1D.IntIndex[orderedSet.size()];
        int index = 0;
        for (Variable variable : orderedSet) {
            if (variable == null || variable.getIndex() == null) {
                throw new ProgrammingError("Variables must be already inserted in the model!");
            }
            sequence[index++] = variable.getIndex();
        }
        ExpressionsBasedModel.addPresolver(new SpecialOrderedSet(sequence, type, linkedTo));
    }

    public void addSpecialOrderedSet(Collection<Variable> orderedSet, int min, int max) {
        if (max <= 0 || min > max) {
            throw new ProgrammingError("Invalid min/max number of ON variables!");
        }
        String name = "SOS" + max + "-" + orderedSet.toString();
        Expression expression = this.addExpression(name);
        for (Variable variable : orderedSet) {
            if (variable == null || variable.getIndex() == null || !variable.isBinary()) {
                throw new ProgrammingError("Variables must be binary and already inserted in the model!");
            }
            expression.set(variable.getIndex(), BigMath.ONE);
        }
        expression.upper(BigDecimal.valueOf(max));
        if (min > 0) {
            expression.lower(BigDecimal.valueOf(min));
        }
        this.addSpecialOrderedSet(orderedSet, max, expression);
    }

    public Variable addVariable() {
        return this.addVariable("X" + this.myVariables.size());
    }

    public Variable addVariable(String name) {
        Variable retVal = new Variable(name);
        this.addVariable(retVal);
        return retVal;
    }

    public void addVariable(Variable variable) {
        if (this.myShallowCopy) {
            throw new IllegalStateException("This model is a work copy - its set of variables cannot be modified!");
        }
        this.myVariables.add(variable);
        variable.setIndex(new Structure1D.IntIndex(this.myVariables.size() - 1));
    }

    public void addVariables(Collection<? extends Variable> variables) {
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
    }

    public void addVariables(Variable[] variables) {
        for (Variable tmpVariable : variables) {
            this.addVariable(tmpVariable);
        }
    }

    public Stream<Variable> bounds() {
        return this.variables().filter(v -> v.isConstraint() && !v.isFixed());
    }

    public boolean checkSimilarity(Expression potential) {
        return Presolvers.checkSimilarity(this.myExpressions.values(), potential);
    }

    public Stream<Expression> constraints() {
        return this.myExpressions.values().stream().filter(c -> c.isConstraint() && !c.isRedundant());
    }

    public ExpressionsBasedModel copy() {
        return new ExpressionsBasedModel(this, false, false);
    }

    public ExpressionsBasedModel copy(boolean relax) {
        ExpressionsBasedModel copy = new ExpressionsBasedModel(this, false, false);
        if (relax) {
            copy.relax(false);
        }
        return copy;
    }

    public ExpressionsBasedModel copy(boolean shallow, boolean prune) {
        return new ExpressionsBasedModel(this, shallow, prune);
    }

    public int countExpressions() {
        return this.myExpressions.size();
    }

    public int countVariables() {
        return this.myVariables.size();
    }

    @Override
    public void dispose() {
        for (Expression tmpExprerssion : this.myExpressions.values()) {
            tmpExprerssion.destroy();
        }
        this.myExpressions.clear();
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.destroy();
        }
        this.myVariables.clear();
        this.myFixedVariables.clear();
        this.myVariablesCategorisation.reset();
    }

    public Expression getExpression(String name) {
        return this.myExpressions.get(name);
    }

    public Collection<Expression> getExpressions() {
        return Collections.unmodifiableCollection(this.myExpressions.values());
    }

    public Set<Structure1D.IntIndex> getFixedVariables() {
        this.myFixedVariables.clear();
        for (Variable tmpVar : this.myVariables) {
            if (!tmpVar.isFixed()) continue;
            this.myFixedVariables.add(tmpVar.getIndex());
        }
        return Collections.unmodifiableSet(this.myFixedVariables);
    }

    public List<Variable> getFreeVariables() {
        return Collections.unmodifiableList(this.myVariablesCategorisation.getFreeVariables(this.myVariables));
    }

    public List<Variable> getIntegerVariables() {
        return Collections.unmodifiableList(this.myVariablesCategorisation.getIntegerVariables(this.myVariables));
    }

    public List<Variable> getNegativeVariables() {
        return Collections.unmodifiableList(this.myVariablesCategorisation.getNegativeVariables(this.myVariables));
    }

    public Optimisation.Sense getOptimisationSense() {
        return this.myOptimisationSense;
    }

    public List<Variable> getPositiveVariables() {
        return Collections.unmodifiableList(this.myVariablesCategorisation.getPositiveVariables(this.myVariables));
    }

    public Variable getVariable(int index) {
        return this.myVariables.get(index);
    }

    public Variable getVariable(Structure1D.IntIndex index) {
        return this.myVariables.get(index.index);
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.myVariables);
    }

    public Optimisation.Result getVariableValues() {
        return this.getVariableValues(this.options.feasibility);
    }

    public Optimisation.Result getVariableValues(NumberContext validationContext) {
        int numberOfVariables = this.myVariables.size();
        Optimisation.State retState = Optimisation.State.UNEXPLORED;
        double retValue = Double.NaN;
        Array1D retSolution = (Array1D)Array1D.BIG.make(numberOfVariables);
        boolean allVarsSomeInfo = true;
        for (int i = 0; i < numberOfVariables; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.getValue() != null) {
                retSolution.set(i, tmpVariable.getValue());
                continue;
            }
            if (tmpVariable.isEqualityConstraint()) {
                retSolution.set(i, tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isLowerLimitSet() && tmpVariable.isUpperLimitSet()) {
                retSolution.set(i, BigMath.DIVIDE.invoke(tmpVariable.getLowerLimit().add(tmpVariable.getUpperLimit()), BigMath.TWO));
                continue;
            }
            if (tmpVariable.isLowerLimitSet()) {
                retSolution.set(i, tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isUpperLimitSet()) {
                retSolution.set(i, tmpVariable.getUpperLimit());
                continue;
            }
            retSolution.set(i, BigMath.ZERO);
            allVarsSomeInfo = false;
        }
        if (allVarsSomeInfo) {
            if (this.validate(retSolution, validationContext, BasicLogger.NULL)) {
                retState = Optimisation.State.FEASIBLE;
                retValue = this.objective().evaluate(retSolution).doubleValue();
            } else {
                retState = Optimisation.State.APPROXIMATE;
            }
        } else {
            retState = Optimisation.State.INFEASIBLE;
        }
        return new Optimisation.Result(retState, retValue, retSolution);
    }

    public int indexOf(Variable variable) {
        return variable.getIndex().index;
    }

    public int indexOfFreeVariable(int globalIndex) {
        return this.myVariablesCategorisation.indexOfFreeVariable(globalIndex, this.myVariables);
    }

    public int indexOfFreeVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfFreeVariable(variableIndex.index);
    }

    public int indexOfFreeVariable(Variable variable) {
        return this.indexOfFreeVariable(this.indexOf(variable));
    }

    public int indexOfIntegerVariable(int globalIndex) {
        return this.myVariablesCategorisation.indexOfIntegerVariable(globalIndex, this.myVariables);
    }

    public int indexOfIntegerVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfIntegerVariable(variableIndex.index);
    }

    public int indexOfIntegerVariable(Variable variable) {
        return this.indexOfIntegerVariable(variable.getIndex().index);
    }

    public int indexOfNegativeVariable(int globalIndex) {
        return this.myVariablesCategorisation.indexOfNegativeVariable(globalIndex, this.myVariables);
    }

    public int indexOfNegativeVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfNegativeVariable(variableIndex.index);
    }

    public int indexOfNegativeVariable(Variable variable) {
        return this.indexOfNegativeVariable(this.indexOf(variable));
    }

    public int indexOfPositiveVariable(int globalIndex) {
        return this.myVariablesCategorisation.indexOfPositiveVariable(globalIndex, this.myVariables);
    }

    public int indexOfPositiveVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfPositiveVariable(variableIndex.index);
    }

    public int indexOfPositiveVariable(Variable variable) {
        return this.indexOfPositiveVariable(this.indexOf(variable));
    }

    public boolean isAnyConstraintQuadratic() {
        boolean retVal = false;
        for (Expression expr : this.myExpressions.values()) {
            retVal |= expr.isConstraint() && !expr.isRedundant() && expr.isAnyQuadraticFactorNonZero();
        }
        return retVal;
    }

    public boolean isAnyExpressionQuadratic() {
        boolean retVal = false;
        for (Expression expr : this.myExpressions.values()) {
            retVal |= expr.isAnyQuadraticFactorNonZero() && (expr.isObjective() || expr.isConstraint() && !expr.isRedundant());
        }
        return retVal;
    }

    public boolean isAnyObjectiveQuadratic() {
        boolean retVal = false;
        for (Expression expr : this.myExpressions.values()) {
            retVal |= expr.isObjective() && expr.isAnyQuadraticFactorNonZero();
        }
        return retVal;
    }

    public boolean isAnyVariableFixed() {
        return this.myVariables.stream().anyMatch(Variable::isFixed);
    }

    public boolean isAnyVariableInteger() {
        Variable variable;
        if (this.myRelaxed) {
            return false;
        }
        boolean retVal = false;
        int limit = this.myVariables.size();
        for (int i = 0; !retVal && i < limit; retVal |= (variable = this.myVariables.get(i)).isInteger() && !variable.isFixed(), ++i) {
        }
        return retVal;
    }

    public Expression limitObjective(BigDecimal lower, BigDecimal upper) {
        Expression objExpr;
        Expression constrExpr = this.myExpressions.get(OBJ_FUNC_AS_CONSTR_KEY);
        if (constrExpr == null && !(objExpr = this.objective()).isAnyQuadraticFactorNonZero()) {
            constrExpr = objExpr.copy(this, false);
            this.myExpressions.put(OBJ_FUNC_AS_CONSTR_KEY, constrExpr);
        }
        if (constrExpr != null) {
            ((Expression)constrExpr.lower(lower)).upper(upper);
            constrExpr.tighten();
        }
        return constrExpr != null ? constrExpr : this.objective();
    }

    @Override
    public Optimisation.Result maximise() {
        this.setOptimisationSense(Optimisation.Sense.MAX);
        return this.optimise();
    }

    @Override
    public Optimisation.Result minimise() {
        this.setOptimisationSense(Optimisation.Sense.MIN);
        return this.optimise();
    }

    public Expression objective() {
        Expression retVal = new Expression(OBJECTIVE, this);
        for (int i = 0; i < this.myVariables.size(); ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (!tmpVariable.isObjective()) continue;
            retVal.set(i, tmpVariable.getContributionWeight());
        }
        BigDecimal tmpOldVal = null;
        BigDecimal tmpDiff = null;
        BigDecimal tmpNewVal = null;
        retVal.setConstant(this.getObjectiveConstant());
        for (Expression tmpExpression : this.myExpressions.values()) {
            boolean tmpNotOne;
            if (!tmpExpression.isObjective()) continue;
            BigDecimal tmpContributionWeight = tmpExpression.getContributionWeight();
            boolean bl = tmpNotOne = tmpContributionWeight.compareTo(BigMath.ONE) != 0;
            if (tmpExpression.isAnyLinearFactorNonZero()) {
                for (Structure1D.IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    tmpOldVal = retVal.get(intIndex);
                    tmpDiff = tmpExpression.get(intIndex);
                    tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                    retVal.set(intIndex, tmpNewVal);
                }
            }
            if (!tmpExpression.isAnyQuadraticFactorNonZero()) continue;
            for (Structure2D.IntRowColumn intRowColumn : tmpExpression.getQuadraticKeySet()) {
                tmpOldVal = retVal.get(intRowColumn);
                tmpDiff = tmpExpression.get(intRowColumn);
                tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                retVal.set(intRowColumn, tmpNewVal);
            }
        }
        return retVal;
    }

    public <T extends IntermediateSolver> T prepare(Function<ExpressionsBasedModel, T> factory) {
        return (T)((IntermediateSolver)factory.apply(this));
    }

    public ExpressionsBasedModel reduce() {
        Presolvers.reduce(this.myExpressions.values());
        return this;
    }

    public void relax() {
        this.relax(false);
    }

    public void relax(boolean soft) {
        if (soft) {
            this.myRelaxed = true;
        } else {
            for (Variable variable : this.myVariables) {
                variable.relax();
            }
        }
    }

    public void removeExpression(String name) {
        this.myExpressions.remove(name);
    }

    public ExpressionsBasedModel simplify() {
        this.scanEntities();
        this.presolve();
        return new ExpressionsBasedModel(this, true, true);
    }

    public ExpressionsBasedModel snapshot() {
        ExpressionsBasedModel shallowCopy = this.copy(true, false);
        shallowCopy.relax(true);
        return shallowCopy;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(START_END);
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.appendToString(retVal);
            retVal.append(NEW_LINE);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            tmpExpression.appendToString(retVal, this.getVariableValues());
            retVal.append(NEW_LINE);
        }
        return retVal.append(START_END).toString();
    }

    @Override
    public boolean validate() {
        BasicLogger.Printer appender = this.options.logger_detailed ? this.options.logger_appender : BasicLogger.NULL;
        boolean retVal = true;
        for (Variable tmpVariable : this.myVariables) {
            retVal &= tmpVariable.validate(appender);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            retVal &= tmpExpression.validate(appender);
        }
        return retVal;
    }

    public boolean validate(Access1D<BigDecimal> solution) {
        NumberContext context = this.options.feasibility;
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context) {
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context, BasicLogger.Printer appender) {
        BigDecimal value;
        Variable tmpVariable;
        ProgrammingError.throwIfNull(solution, (Object)context, (Object)appender);
        int size = this.myVariables.size();
        boolean retVal = (long)size == solution.count();
        for (int i = 0; retVal && i < size; retVal &= tmpVariable.validate(value, context, appender, this.myRelaxed), ++i) {
            tmpVariable = this.myVariables.get(i);
            value = solution.get(i);
        }
        if (retVal) {
            for (Expression tmpExpression : this.myExpressions.values()) {
                value = tmpExpression.evaluate(solution);
                retVal &= tmpExpression.validate(value, context, appender);
            }
        }
        return retVal;
    }

    public boolean validate(Access1D<BigDecimal> solution, BasicLogger.Printer appender) {
        NumberContext context = this.options.feasibility;
        return this.validate(solution, context, appender);
    }

    public boolean validate(NumberContext context) {
        Optimisation.Result solution = this.getVariableValues(context);
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(NumberContext context, BasicLogger.Printer appender) {
        Optimisation.Result solution = this.getVariableValues(context);
        return this.validate(solution, context, appender);
    }

    public boolean validate(BasicLogger.Printer appender) {
        NumberContext context = this.options.feasibility;
        Optimisation.Result solution = this.getVariableValues(context);
        return this.validate(solution, context, appender);
    }

    public Stream<Variable> variables() {
        return this.myVariables.stream().filter(v -> !v.isEqualityConstraint());
    }

    public void writeTo(File file) {
        try (FileOutputStream output = new FileOutputStream(file);){
            FileFormatEBM.write(this, output);
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    private Optimisation.Result optimise() {
        if (!this.myShallowCopy && PRESOLVERS.size() > 0) {
            this.scanEntities();
        }
        DefaultIntermediate prepared = this.prepare(DefaultIntermediate::new);
        Optimisation.Result result = prepared.solve(null);
        int limit = this.myVariables.size();
        for (int i = 0; i < limit; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.isFixed()) continue;
            tmpVariable.setValue(this.options.solution.toBigDecimal(result.doubleValue(i)));
        }
        Optimisation.Result retSolution = this.getVariableValues();
        double retValue = this.objective().evaluate(retSolution).doubleValue();
        Optimisation.State retState = result.getState();
        prepared.dispose();
        return new Optimisation.Result(retState, retValue, retSolution);
    }

    private void scanEntities() {
        boolean anyVarInt = this.isAnyVariableInteger();
        for (Expression tmpExpr : this.myExpressions.values()) {
            Set<Structure1D.IntIndex> allVars = tmpExpr.getLinearKeySet();
            BigDecimal lower = tmpExpr.getLowerLimit();
            BigDecimal upper = tmpExpr.getUpperLimit();
            if (tmpExpr.isObjective()) {
                Presolvers.LINEAR_OBJECTIVE.simplify(tmpExpr, allVars, lower, upper, this.options.feasibility);
            }
            if (!tmpExpr.isConstraint()) continue;
            if (anyVarInt) {
                tmpExpr.isInteger();
            }
            Presolvers.ZERO_ONE_TWO.simplify(tmpExpr, allVars, lower, upper, this.options.feasibility);
        }
        for (Variable tmpVar : this.myVariables) {
            Presolvers.UNREFERENCED.simplify(tmpVar, this);
            if (!anyVarInt || !tmpVar.isInteger() || !tmpVar.isConstraint()) continue;
            tmpVar.doIntegerRounding();
        }
    }

    void addObjectiveConstant(BigDecimal addition) {
        if (addition != null && addition.signum() != 0) {
            this.myObjectiveConstant = this.myObjectiveConstant.add(addition);
        }
    }

    void addReference(Structure1D.IntIndex index) {
        this.myReferences.add(index);
    }

    int deriveAdjustmentRange(Expression expression) {
        int retVal = 0;
        for (Structure1D.IntIndex linear : expression.getLinearKeySet()) {
            retVal = Math.max(retVal, Math.abs(this.myVariables.get(linear.index).getAdjustmentExponent()));
        }
        for (Structure2D.IntRowColumn quadratic : expression.getQuadraticKeySet()) {
            retVal = Math.max(retVal, Math.abs(this.myVariables.get(quadratic.row).getAdjustmentExponent()));
            retVal = Math.max(retVal, Math.abs(this.myVariables.get(quadratic.column).getAdjustmentExponent()));
        }
        return retVal;
    }

    Stream<Expression> expressions() {
        return this.myExpressions.values().stream();
    }

    Integration<?> getIntegration() {
        Integration retVal = null;
        for (IntegerSolver.ModelIntegration modelIntegration : INTEGRATIONS) {
            if (!modelIntegration.isCapable(this)) continue;
            retVal = modelIntegration;
            break;
        }
        if (retVal == null) {
            if (this.isAnyVariableInteger()) {
                if (IntegerSolver.INTEGRATION.isCapable(this)) {
                    retVal = IntegerSolver.INTEGRATION;
                }
            } else if (ConvexSolver.INTEGRATION.isCapable(this)) {
                retVal = ConvexSolver.INTEGRATION;
            } else if (LinearSolver.INTEGRATION.isCapable(this)) {
                retVal = LinearSolver.INTEGRATION;
            }
        }
        if (retVal == null) {
            throw new ProgrammingError("No solver integration available that can handle this model!");
        }
        return retVal;
    }

    BigDecimal getObjectiveConstant() {
        return this.myObjectiveConstant;
    }

    Set<Structure1D.IntIndex> getReferences() {
        return this.myReferences;
    }

    boolean isFixed() {
        return this.myVariables.stream().allMatch(Variable::isFixed);
    }

    boolean isInfeasible() {
        if (this.myInfeasible) {
            return true;
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            if (!tmpExpression.isInfeasible()) continue;
            this.myInfeasible = true;
            return true;
        }
        for (Variable tmpVariable : this.myVariables) {
            if (!tmpVariable.isInfeasible()) continue;
            this.myInfeasible = true;
            return true;
        }
        return false;
    }

    boolean isReferenced(Variable variable) {
        return this.myReferences.contains(variable.getIndex());
    }

    boolean isRelaxed() {
        return this.myRelaxed;
    }

    boolean isShallowCopy() {
        return this.myShallowCopy;
    }

    boolean isUnbounded() {
        return this.myVariables.stream().anyMatch(Variable::isUnbounded);
    }

    void presolve() {
        BigDecimal compensatedUpperLimit;
        BigDecimal compensatedLowerLimit;
        BigDecimal calculateSetValue;
        Set<Structure1D.IntIndex> fixedVariables;
        boolean needToRepeat = false;
        do {
            fixedVariables = this.getFixedVariables();
            needToRepeat = false;
            for (Expression expr : this.getExpressions()) {
                if (needToRepeat || !expr.isConstraint() || expr.isInfeasible() || expr.isRedundant() || expr.countQuadraticFactors() != 0) continue;
                calculateSetValue = expr.calculateSetValue(fixedVariables);
                compensatedLowerLimit = expr.getCompensatedLowerLimit(calculateSetValue);
                compensatedUpperLimit = expr.getCompensatedUpperLimit(calculateSetValue);
                this.myTemporary.clear();
                this.myTemporary.addAll(expr.getLinearKeySet());
                this.myTemporary.removeAll(fixedVariables);
                for (Presolver presolver : PRESOLVERS) {
                    if (needToRepeat) continue;
                    needToRepeat |= presolver.simplify(expr, this.myTemporary, compensatedLowerLimit, compensatedUpperLimit, this.options.feasibility);
                }
            }
        } while (needToRepeat);
        if (!this.isInfeasible()) {
            fixedVariables = this.getFixedVariables();
            for (Expression expr : this.getExpressions()) {
                if (!expr.isConstraint() || !expr.isRedundant() || expr.countQuadraticFactors() != 0) continue;
                calculateSetValue = expr.calculateSetValue(fixedVariables);
                compensatedLowerLimit = expr.getCompensatedLowerLimit(calculateSetValue);
                compensatedUpperLimit = expr.getCompensatedUpperLimit(calculateSetValue);
                this.myTemporary.clear();
                this.myTemporary.addAll(expr.getLinearKeySet());
                this.myTemporary.removeAll(fixedVariables);
                Presolvers.checkFeasibility(expr, this.myTemporary, compensatedLowerLimit, compensatedUpperLimit, this.options.feasibility, this.myRelaxed);
            }
        }
        if (!this.myShallowCopy) {
            // empty if block
        }
        this.myVariablesCategorisation.update(this.myVariables);
    }

    void setInfeasible() {
        this.myInfeasible = true;
    }

    void setOptimisationSense(Optimisation.Sense optimisationSense) {
        this.myOptimisationSense = optimisationSense;
    }

    static {
        ExpressionsBasedModel.addPresolver(Presolvers.ZERO_ONE_TWO);
        ExpressionsBasedModel.addPresolver(Presolvers.REDUNDANT_CONSTRAINT);
    }

    static final class VariablesCategorisation {
        private transient int[] myFreeIndices = null;
        private final List<Variable> myFreeVariables = new ArrayList<Variable>();
        private transient int[] myIntegerIndices = null;
        private final List<Variable> myIntegerVariables = new ArrayList<Variable>();
        private transient int[] myNegativeIndices = null;
        private final List<Variable> myNegativeVariables = new ArrayList<Variable>();
        private transient int[] myPositiveIndices = null;
        private final List<Variable> myPositiveVariables = new ArrayList<Variable>();

        VariablesCategorisation() {
        }

        private void free(ArrayList<Variable> variables) {
            if (this.myFreeIndices == null || this.myFreeIndices.length != variables.size()) {
                this.update(variables);
            }
        }

        private void integer(ArrayList<Variable> variables) {
            if (this.myIntegerIndices == null || this.myIntegerIndices.length != variables.size()) {
                this.update(variables);
            }
        }

        private void negative(ArrayList<Variable> variables) {
            if (this.myNegativeIndices == null || this.myNegativeIndices.length != variables.size()) {
                this.update(variables);
            }
        }

        private void positive(ArrayList<Variable> variables) {
            if (this.myPositiveIndices == null || this.myPositiveIndices.length != variables.size()) {
                this.update(variables);
            }
        }

        List<Variable> getFreeVariables(ArrayList<Variable> variables) {
            this.free(variables);
            return this.myFreeVariables;
        }

        List<Variable> getIntegerVariables(ArrayList<Variable> variables) {
            this.integer(variables);
            return this.myIntegerVariables;
        }

        List<Variable> getNegativeVariables(ArrayList<Variable> variables) {
            this.negative(variables);
            return this.myNegativeVariables;
        }

        List<Variable> getPositiveVariables(ArrayList<Variable> variables) {
            this.positive(variables);
            return this.myPositiveVariables;
        }

        int indexOfFreeVariable(int globalIndex, ArrayList<Variable> variables) {
            this.free(variables);
            return this.myFreeIndices[globalIndex];
        }

        int indexOfIntegerVariable(int globalIndex, ArrayList<Variable> variables) {
            this.integer(variables);
            return this.myIntegerIndices[globalIndex];
        }

        int indexOfNegativeVariable(int globalIndex, ArrayList<Variable> variables) {
            this.negative(variables);
            return this.myNegativeIndices[globalIndex];
        }

        int indexOfPositiveVariable(int globalIndex, ArrayList<Variable> variables) {
            this.positive(variables);
            return this.myPositiveIndices[globalIndex];
        }

        void reset() {
            this.myFreeVariables.clear();
            this.myFreeIndices = null;
            this.myPositiveVariables.clear();
            this.myPositiveIndices = null;
            this.myNegativeVariables.clear();
            this.myNegativeIndices = null;
            this.myIntegerVariables.clear();
            this.myIntegerIndices = null;
        }

        void update(ArrayList<Variable> variables) {
            int nbVariables = variables.size();
            this.myFreeVariables.clear();
            this.myFreeIndices = new int[nbVariables];
            Arrays.fill(this.myFreeIndices, -1);
            this.myPositiveVariables.clear();
            this.myPositiveIndices = new int[nbVariables];
            Arrays.fill(this.myPositiveIndices, -1);
            this.myNegativeVariables.clear();
            this.myNegativeIndices = new int[nbVariables];
            Arrays.fill(this.myNegativeIndices, -1);
            this.myIntegerVariables.clear();
            this.myIntegerIndices = new int[nbVariables];
            Arrays.fill(this.myIntegerIndices, -1);
            for (int i = 0; i < nbVariables; ++i) {
                Variable tmpVariable = variables.get(i);
                if (tmpVariable.isFixed()) continue;
                this.myFreeVariables.add(tmpVariable);
                this.myFreeIndices[i] = this.myFreeVariables.size() - 1;
                if (!tmpVariable.isUpperLimitSet() || tmpVariable.getUpperLimit().signum() == 1) {
                    this.myPositiveVariables.add(tmpVariable);
                    this.myPositiveIndices[i] = this.myPositiveVariables.size() - 1;
                }
                if (!tmpVariable.isLowerLimitSet() || tmpVariable.getLowerLimit().signum() == -1) {
                    this.myNegativeVariables.add(tmpVariable);
                    this.myNegativeIndices[i] = this.myNegativeVariables.size() - 1;
                }
                if (!tmpVariable.isInteger()) continue;
                this.myIntegerVariables.add(tmpVariable);
                this.myIntegerIndices[i] = this.myIntegerVariables.size() - 1;
            }
        }
    }

    static abstract class VariableAnalyser
    extends Simplifier<Variable, VariableAnalyser> {
        protected VariableAnalyser(int executionOrder) {
            super(executionOrder);
        }

        public abstract boolean simplify(Variable var1, ExpressionsBasedModel var2);

        @Override
        boolean isApplicable(Variable target) {
            return true;
        }
    }

    static abstract class Simplifier<ME extends ModelEntity<?>, S extends Simplifier<?, ?>>
    implements Comparable<S> {
        private final int myExecutionOrder;
        private final UUID myUUID = UUID.randomUUID();

        Simplifier(int executionOrder) {
            this.myExecutionOrder = executionOrder;
        }

        @Override
        public final int compareTo(S reference) {
            return Integer.compare(this.myExecutionOrder, ((Simplifier)reference).getExecutionOrder());
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Simplifier)) {
                return false;
            }
            Simplifier other = (Simplifier)obj;
            return !(this.myUUID == null ? other.myUUID != null : !this.myUUID.equals(other.myUUID));
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            return 31 * result + (this.myUUID == null ? 0 : this.myUUID.hashCode());
        }

        final int getExecutionOrder() {
            return this.myExecutionOrder;
        }

        abstract boolean isApplicable(ME var1);
    }

    static final class DefaultIntermediate
    extends IntermediateSolver {
        DefaultIntermediate(ExpressionsBasedModel model) {
            super(model);
        }
    }

    public static abstract class Presolver
    extends Simplifier<Expression, Presolver> {
        protected Presolver(int executionOrder) {
            super(executionOrder);
        }

        public abstract boolean simplify(Expression var1, Set<Structure1D.IntIndex> var2, BigDecimal var3, BigDecimal var4, NumberContext var5);

        @Override
        boolean isApplicable(Expression target) {
            return target.isConstraint() && !target.isInfeasible() && !target.isRedundant() && target.countQuadraticFactors() == 0;
        }
    }

    public static abstract class Integration<S extends Optimisation.Solver>
    implements Optimisation.Integration<ExpressionsBasedModel, S> {
        @Override
        public final Optimisation.Result extractSolverState(ExpressionsBasedModel model) {
            return this.toSolverState(model.getVariableValues(), model);
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            int numbVariables = model.countVariables();
            if (this.isSolutionMapped()) {
                List<Variable> freeVariables = model.getFreeVariables();
                Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
                if (solverState.count() != (long)freeVariables.size()) {
                    throw new IllegalStateException();
                }
                Primitive64Array modelSolution = Primitive64Array.make(numbVariables);
                for (Structure1D.IntIndex fixedIndex : fixedVariables) {
                    modelSolution.set((long)fixedIndex.index, model.getVariable(fixedIndex.index).getValue());
                }
                for (int f = 0; f < freeVariables.size(); ++f) {
                    int freeIndex = model.indexOf(freeVariables.get(f));
                    modelSolution.set((long)freeIndex, solverState.doubleValue(f));
                }
                return new Optimisation.Result(solverState.getState(), modelSolution);
            }
            if (solverState.count() != (long)numbVariables) {
                throw new IllegalStateException();
            }
            return solverState;
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            if (!this.isSolutionMapped()) {
                return modelState;
            }
            List<Variable> tmpFreeVariables = model.getFreeVariables();
            int numbFreeVars = tmpFreeVariables.size();
            Primitive64Array solverSolution = Primitive64Array.make(numbFreeVars);
            for (int i = 0; i < numbFreeVars; ++i) {
                Variable variable = tmpFreeVariables.get(i);
                int modelIndex = model.indexOf(variable);
                solverSolution.set((long)i, modelState.doubleValue(modelIndex));
            }
            return new Optimisation.Result(modelState.getState(), solverSolution);
        }

        protected int getIndexInSolver(ExpressionsBasedModel model, Variable variable) {
            return model.indexOfFreeVariable(variable);
        }

        protected abstract boolean isSolutionMapped();
    }

    public static enum FileFormat {
        EBM,
        MPS;


        public static FileFormat from(File file) {
            return FileFormat.from(file.getPath());
        }

        public static FileFormat from(String path) {
            String lowerCasePath = path.toLowerCase();
            if (lowerCasePath.endsWith("mps") || lowerCasePath.endsWith("sif")) {
                return MPS;
            }
            if (lowerCasePath.endsWith("ebm")) {
                return EBM;
            }
            throw new IllegalArgumentException();
        }
    }
}

