/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.task.iterative.StationaryIterativeSolver;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public final class JacobiSolver
extends StationaryIterativeSolver {
    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> current) throws RecoverableCondition {
        MatrixStore tmpBody = null;
        tmpBody = body instanceof MatrixStore && body.get(0L) instanceof Double ? (MatrixStore)body : Primitive64Store.FACTORY.makeWrapper(body);
        MatrixStore tmpBodyDiagonal = (MatrixStore)Primitive64Store.FACTORY.columns(tmpBody.sliceDiagonal());
        MatrixStore tmpRHS = null;
        tmpRHS = rhs instanceof MatrixStore && rhs.get(0L) instanceof Double ? (MatrixStore)rhs : Primitive64Store.FACTORY.makeWrapper(rhs);
        PhysicalStore<Double> tmpIncrement = this.preallocate(body, rhs);
        PhysicalStore<Double> incremetReceiver = body.isFat() ? tmpIncrement.regionByLimits((int)body.countRows(), 1) : tmpIncrement;
        double tmpNormErr = Double.POSITIVE_INFINITY;
        double tmpNormRHS = (Double)tmpRHS.aggregateAll(Aggregator.NORM2);
        int tmpIterations = 0;
        int tmpLimit = this.getIterationsLimit();
        NumberContext tmpCntxt = this.getAccuracyContext();
        double tmpRelaxation = this.getRelaxationFactor();
        do {
            current.premultiply(tmpBody).onMatching((Access2D)tmpRHS, (BinaryFunction)PrimitiveMath.SUBTRACT).supplyTo(incremetReceiver);
            tmpNormErr = (Double)tmpIncrement.aggregateAll(Aggregator.NORM2);
            tmpIncrement.modifyMatching(PrimitiveMath.DIVIDE, tmpBodyDiagonal);
            if (this.getAccuracyContext().isDifferent(PrimitiveMath.ONE, tmpRelaxation)) {
                tmpIncrement.multiply(tmpRelaxation);
            }
            current.modifyMatching(PrimitiveMath.ADD, tmpIncrement);
            ++tmpIterations;
            if (!this.isDebugPrinterSet()) continue;
            this.debug(tmpIterations, tmpNormErr / tmpNormRHS, current);
        } while (tmpIterations < tmpLimit && !tmpCntxt.isSmall(tmpNormRHS, tmpNormErr));
        return current;
    }
}

