/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;

final class RepeatedRowsStore<N extends Comparable<N>>
extends ComposingStore<N> {
    private final long myBaseRows;
    private final int myRepetitions;

    RepeatedRowsStore(MatrixStore<N> base, int repetitions) {
        super(base, base.countRows() * (long)repetitions, base.countColumns());
        this.myRepetitions = repetitions;
        this.myBaseRows = base.countRows();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.base().doubleValue(row % this.myBaseRows, col);
    }

    @Override
    public N get(long row, long col) {
        return this.base().get(row % this.myBaseRows, col);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        for (long br = 0L; br < this.myBaseRows; ++br) {
            Access1D row = this.base().sliceRow(br);
            for (long r = 0L; r < (long)this.myRepetitions; ++r) {
                receiver.fillRow(br + this.myBaseRows * r, row);
            }
        }
    }
}

