/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.Future;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.matrix.store.AbstractStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

abstract class LogicalStore<N extends Comparable<N>>
extends AbstractStore<N> {
    private final MatrixStore<N> myBase;
    private final Scalar<N> myOne;
    private final Scalar<N> myZero;

    protected LogicalStore(MatrixStore<N> base, int rowsCount, int columnsCount) {
        super(rowsCount, columnsCount);
        this.myBase = base;
        this.myZero = base.physical().scalar().zero();
        this.myOne = base.physical().scalar().one();
    }

    protected LogicalStore(MatrixStore<N> base, long rowsCount, long columnsCount) {
        this(base, Math.toIntExact(rowsCount), Math.toIntExact(columnsCount));
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myBase.physical();
    }

    protected final Future<?> executeMultiply(Access1D<N> right, TransformableRegion<N> target) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(right, target));
    }

    protected final Future<MatrixStore<N>> executeMultiply(double scalar) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(scalar));
    }

    protected final Future<MatrixStore<N>> executeMultiply(MatrixStore<N> right) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(right));
    }

    protected final Future<MatrixStore<N>> executeMultiply(N scalar) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply((Comparable)scalar));
    }

    protected final Future<N> executeMultiplyBoth(Access1D<N> leftAndRight) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiplyBoth(leftAndRight));
    }

    protected final Future<ElementsSupplier<N>> executePremultiply(Access1D<N> left) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.premultiply(left));
    }

    final MatrixStore<N> base() {
        return this.myBase;
    }

    final Scalar<N> one() {
        return this.myOne;
    }

    final Scalar<N> zero() {
        return this.myZero;
    }
}

