/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.LowerUpper;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.TypeUtils;

public final class PortfolioMixer {
    private static final String ACTIVE = "_Active";
    private static final String B = "B";
    private static final String C = "C";
    private static final String DIMENSION_MISMATCH = "The target and component portfolios must all have the same number of contained assets!";
    private static final String QUADRATIC_OBJECTIVE_PART = "Quadratic Objective Part";
    private static final String STRATEGY_COUNT = "Strategy Count";
    private final ArrayList<FinancePortfolio> myComponents;
    private final FinancePortfolio myTarget;
    private final HashMap<int[], LowerUpper> myAssetConstraints = new HashMap();
    private final HashMap<int[], LowerUpper> myComponentConstraints = new HashMap();

    public PortfolioMixer(FinancePortfolio target, Collection<? extends FinancePortfolio> components) {
        this(target, components.toArray(new FinancePortfolio[components.size()]));
    }

    public PortfolioMixer(FinancePortfolio target, FinancePortfolio ... components) {
        this.myTarget = target;
        int tmpSize = this.myTarget.getWeights().size();
        this.myComponents = new ArrayList();
        for (FinancePortfolio tmpCompPortf : components) {
            if (tmpCompPortf.getWeights().size() != tmpSize) {
                throw new IllegalArgumentException(DIMENSION_MISMATCH);
            }
            this.myComponents.add(tmpCompPortf);
        }
    }

    public LowerUpper addAssetConstraint(Comparable<?> lowerLimit, Comparable<?> upperLimit, int ... assetIndeces) {
        return this.myAssetConstraints.put(assetIndeces, new LowerUpper(lowerLimit, upperLimit));
    }

    public LowerUpper addComponentConstraint(Comparable<?> lowerLimit, Comparable<?> upperLimit, int ... assetIndeces) {
        return this.myComponentConstraints.put(assetIndeces, new LowerUpper(lowerLimit, upperLimit));
    }

    public List<BigDecimal> mix(int aNumber) {
        int c;
        Expression tmpExpr;
        BigDecimal tmpUpper;
        BigDecimal tmpLower;
        int tmpIndex;
        int tmpNumberOfAssets = this.myTarget.getWeights().size();
        int tmpNumberOfComponents = this.myComponents.size();
        Variable[] tmpVariables = new Variable[2 * tmpNumberOfComponents];
        for (int c2 = 0; c2 < tmpNumberOfComponents; ++c2) {
            Variable tmpVariable = new Variable(C + c2);
            BigDecimal tmpVal = BigMath.ZERO;
            for (int i = 0; i < tmpNumberOfAssets; ++i) {
                tmpVal = tmpVal.add(this.myTarget.getWeights().get(i).multiply(this.myComponents.get(c2).getWeights().get(i)));
            }
            tmpVal = tmpVal.multiply(BigMath.TWO).negate();
            tmpVariable.weight(tmpVal);
            tmpVariable.lower((Comparable)BigMath.ZERO);
            tmpVariable.upper((Comparable)BigMath.ONE);
            tmpVariables[c2] = tmpVariable;
            tmpVariables[tmpNumberOfComponents + c2] = Variable.makeBinary(B + c2);
        }
        ExpressionsBasedModel tmpModel = new ExpressionsBasedModel(tmpVariables);
        Expression tmpQuadObj = tmpModel.addExpression(QUADRATIC_OBJECTIVE_PART);
        tmpQuadObj.weight(BigMath.ONE);
        for (int row = 0; row < tmpNumberOfComponents; ++row) {
            for (int col = 0; col < tmpNumberOfComponents; ++col) {
                BigDecimal tmpVal = BigMath.ZERO;
                for (int i = 0; i < tmpNumberOfAssets; ++i) {
                    tmpVal = tmpVal.add(this.myComponents.get(row).getWeights().get(i).multiply(this.myComponents.get(col).getWeights().get(i)));
                }
                tmpQuadObj.set(row, col, tmpVal);
                tmpQuadObj.set(tmpNumberOfComponents + row, tmpNumberOfComponents + col, tmpVal.multiply(BigMath.THOUSANDTH));
            }
            Expression tmpActive = tmpModel.addExpression(tmpVariables[row].getName() + ACTIVE);
            tmpActive.set(row, BigMath.NEG);
            tmpActive.set(tmpNumberOfComponents + row, BigMath.ONE);
            tmpActive.lower(BigMath.ZERO);
        }
        Expression tmpHundredPercent = tmpModel.addExpression("100%");
        tmpHundredPercent.level(BigMath.ONE);
        for (int c3 = 0; c3 < tmpNumberOfComponents; ++c3) {
            tmpHundredPercent.set(c3, BigMath.ONE);
        }
        Expression tmpStrategyCount = tmpModel.addExpression(STRATEGY_COUNT);
        tmpStrategyCount.upper(TypeUtils.toBigDecimal(Integer.valueOf(aNumber)));
        for (int c4 = 0; c4 < tmpNumberOfComponents; ++c4) {
            tmpStrategyCount.set(tmpNumberOfComponents + c4, BigMath.ONE);
        }
        for (Map.Entry<int[], LowerUpper> tmpEntry : this.myAssetConstraints.entrySet()) {
            tmpIndex = tmpEntry.getKey()[0];
            tmpLower = tmpEntry.getValue().lower;
            tmpUpper = tmpEntry.getValue().upper;
            tmpExpr = tmpModel.addExpression("AC" + Arrays.toString(tmpEntry.getKey()));
            for (c = 0; c < tmpNumberOfComponents; ++c) {
                tmpExpr.set(c, (Comparable)this.myComponents.get(c).getWeights().get(tmpIndex));
            }
            if (tmpLower != null) {
                tmpExpr.lower(tmpLower);
            }
            if (tmpUpper == null) continue;
            tmpExpr.upper(tmpUpper);
        }
        for (Map.Entry<int[], LowerUpper> tmpEntry : this.myComponentConstraints.entrySet()) {
            tmpIndex = tmpEntry.getKey()[0];
            tmpLower = tmpEntry.getValue().lower;
            tmpUpper = tmpEntry.getValue().upper;
            tmpExpr = tmpModel.addExpression("CC" + Arrays.toString(tmpEntry.getKey()));
            tmpExpr.set(tmpIndex, BigMath.ONE);
            for (c = 0; c < tmpNumberOfComponents; ++c) {
            }
            if (tmpLower != null) {
                tmpExpr.lower(tmpLower);
            }
            if (tmpUpper == null) continue;
            tmpExpr.upper(tmpUpper);
        }
        tmpModel.minimise();
        ArrayList<BigDecimal> retVal = new ArrayList<BigDecimal>(tmpNumberOfComponents);
        for (int v = 0; v < tmpNumberOfComponents; ++v) {
            retVal.add(tmpVariables[v].getValue());
        }
        return retVal;
    }
}

