/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;

public final class MultiviewSet<T> {
    private final Set<T> myCommonSet = ConcurrentHashMap.newKeySet();
    private final Collection<PrioritisedView> myViews = new LinkedBlockingDeque<PrioritisedView>();
    private final boolean myRemoveFromViews;

    public MultiviewSet() {
        this(false);
    }

    public MultiviewSet(boolean removeFromViews) {
        this.myRemoveFromViews = removeFromViews;
    }

    public boolean add(T entry) {
        boolean retVal = this.myCommonSet.add(entry);
        if (retVal) {
            for (PrioritisedView view : this.myViews) {
                view.add(entry);
            }
        }
        return retVal;
    }

    public void clear() {
        this.myCommonSet.clear();
        for (PrioritisedView view : this.myViews) {
            view.clear();
        }
    }

    public boolean isAnyContents() {
        if (!this.isEmpty()) {
            return true;
        }
        for (PrioritisedView view : this.myViews) {
            if (view.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.myCommonSet.isEmpty();
    }

    public PrioritisedView newView(Comparator<? super T> comparator) {
        PrioritisedView view = new PrioritisedView(this.myCommonSet, comparator);
        this.myViews.add(view);
        return view;
    }

    public boolean remove(T entry) {
        boolean retVal = this.myCommonSet.remove(entry);
        if (this.myRemoveFromViews && retVal) {
            for (PrioritisedView view : this.myViews) {
                view.remove(entry);
            }
        }
        return retVal;
    }

    public int size() {
        return this.myCommonSet.size();
    }

    public final class PrioritisedView {
        private final PriorityBlockingQueue<T> myQueue;

        PrioritisedView(Set<T> initial, Comparator<? super T> comparator) {
            this.myQueue = new PriorityBlockingQueue(Math.max(9, initial.size()), comparator);
            this.myQueue.addAll(initial);
        }

        public boolean isEmpty() {
            return this.myQueue.isEmpty();
        }

        public void offer(T entry) {
            MultiviewSet.this.add(entry);
        }

        public T poll() {
            Object candidate = null;
            while ((candidate = (Object)this.myQueue.poll()) != null && !MultiviewSet.this.remove(candidate)) {
            }
            return candidate;
        }

        public int size() {
            return this.myQueue.size();
        }

        boolean add(T entry) {
            return this.myQueue.add(entry);
        }

        void clear() {
            this.myQueue.clear();
        }

        boolean remove(Object entry) {
            return this.myQueue.remove(entry);
        }
    }
}

