/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst;

import java.io.IOException;
import org.apache.lucene.store.RandomAccessInput;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FST;

final class ReverseRandomAccessReader
extends FST.BytesReader {
    private final RandomAccessInput in;
    private long pos;

    ReverseRandomAccessReader(RandomAccessInput in) {
        this.in = in;
    }

    public byte readByte() throws IOException {
        return this.in.readByte(this.pos--);
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int i = offset;
        int end = offset + len;
        while (i < end) {
            b[i++] = this.in.readByte(this.pos--);
        }
    }

    public void skipBytes(long count) {
        this.pos -= count;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = pos;
    }

    @Override
    public boolean reversed() {
        return true;
    }
}

