/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

@Deprecated
public final class Lucene50FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene50FieldInfos";
    static final int FORMAT_SAFE_MAPS = 1;
    static final int FORMAT_START = 1;
    static final int FORMAT_CURRENT = 1;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        try (ChecksumIndexInput input = EndiannessReverserUtil.openChecksumInput((Directory)directory, (String)fileName, (IOContext)context);){
            Throwable priorE = null;
            FieldInfo[] infos = null;
            try {
                CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)1, (int)1, (byte[])segmentInfo.getId(), (String)segmentSuffix);
                int size = input.readVInt();
                infos = new FieldInfo[size];
                Map lastAttributes = Collections.emptyMap();
                for (int i = 0; i < size; ++i) {
                    String name = input.readString();
                    int fieldNumber = input.readVInt();
                    if (fieldNumber < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input);
                    }
                    byte bits = input.readByte();
                    boolean storeTermVector = (bits & 1) != 0;
                    boolean omitNorms = (bits & 2) != 0;
                    boolean storePayloads = (bits & 4) != 0;
                    IndexOptions indexOptions = Lucene50FieldInfosFormat.getIndexOptions((IndexInput)input, input.readByte());
                    DocValuesType docValuesType = Lucene50FieldInfosFormat.getDocValuesType((IndexInput)input, input.readByte());
                    long dvGen = input.readLong();
                    Map attributes = input.readMapOfStrings();
                    if (attributes.equals(lastAttributes)) {
                        attributes = lastAttributes;
                    }
                    lastAttributes = attributes;
                    try {
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, DocValuesSkipIndexType.NONE, dvGen, attributes, 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
                        infos[i].checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException e) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input, (Throwable)e);
                    }
                }
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        return switch (b) {
            case 0 -> DocValuesType.NONE;
            case 1 -> DocValuesType.NUMERIC;
            case 2 -> DocValuesType.BINARY;
            case 3 -> DocValuesType.SORTED;
            case 4 -> DocValuesType.SORTED_SET;
            case 5 -> DocValuesType.SORTED_NUMERIC;
            default -> throw new CorruptIndexException("invalid docvalues byte: " + b, (DataInput)input);
        };
    }

    private static IndexOptions getIndexOptions(IndexInput input, byte b) throws IOException {
        return switch (b) {
            case 0 -> IndexOptions.NONE;
            case 1 -> IndexOptions.DOCS;
            case 2 -> IndexOptions.DOCS_AND_FREQS;
            case 3 -> IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            case 4 -> IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            default -> throw new CorruptIndexException("invalid IndexOptions byte: " + b, (DataInput)input);
        };
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) {
        throw new UnsupportedOperationException();
    }
}

