/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.TimeProvider;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.repositories.gcs.GcsRepositoryStatsCollector;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageRepository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class GoogleCloudStoragePlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private final Settings settings;
    final SetOnce<GoogleCloudStorageService> storageService = new SetOnce();

    public GoogleCloudStoragePlugin(Settings settings) {
        this.settings = settings;
    }

    protected GoogleCloudStorageService createStorageService(ClusterService clusterService, ProjectResolver projectResolver) {
        return new GoogleCloudStorageService(clusterService, projectResolver);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics, SnapshotMetrics snapshotMetrics) {
        return Collections.singletonMap("gcs", (projectId, metadata) -> new GoogleCloudStorageRepository(projectId, metadata, namedXContentRegistry, (GoogleCloudStorageService)this.storageService.get(), clusterService, bigArrays, recoverySettings, new GcsRepositoryStatsCollector((TimeProvider)clusterService.threadPool(), metadata, repositoriesMetrics), snapshotMetrics));
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ClusterService clusterService = services.clusterService();
        this.storageService.set((Object)this.createStorageService(clusterService, services.projectResolver()));
        this.reload(this.settings);
        return List.of((GoogleCloudStorageService)this.storageService.get());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(GoogleCloudStorageClientSettings.CREDENTIALS_FILE_SETTING, GoogleCloudStorageClientSettings.ENDPOINT_SETTING, GoogleCloudStorageClientSettings.PROJECT_ID_SETTING, GoogleCloudStorageClientSettings.CONNECT_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.READ_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.APPLICATION_NAME_SETTING, GoogleCloudStorageClientSettings.TOKEN_URI_SETTING, GoogleCloudStorageClientSettings.PROXY_TYPE_SETTING, GoogleCloudStorageClientSettings.PROXY_HOST_SETTING, GoogleCloudStorageClientSettings.PROXY_PORT_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, GoogleCloudStorageClientSettings> clientsSettings = GoogleCloudStorageClientSettings.load(settings);
        ((GoogleCloudStorageService)this.storageService.get()).refreshAndClearCache(clientsSettings);
    }
}

