/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;

public final class WatcherUtils {
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");

    private WatcherUtils() {
    }

    public static Map<String, Object> responseToData(ToXContentObject response, ToXContent.Params params) throws IOException {
        return (Map)XContentHelper.convertToMap((BytesReference)XContentHelper.toXContent((ToXContent)response, (XContentType)XContentType.SMILE, (ToXContent.Params)params, (boolean)false), (boolean)false, (XContentType)XContentType.SMILE).v2();
    }

    public static Map<String, Object> flattenModel(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WatcherUtils.flattenModel("", map, result);
        return result;
    }

    private static void flattenModel(String key, Object value, Map<String, Object> result) {
        if (value == null) {
            result.put(key, null);
            return;
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if ("".equals(key)) {
                    WatcherUtils.flattenModel((String)entry.getKey(), entry.getValue(), result);
                    continue;
                }
                WatcherUtils.flattenModel(key + "." + (String)entry.getKey(), entry.getValue(), result);
            }
            return;
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object item : (Iterable)value) {
                WatcherUtils.flattenModel(key + "." + i++, item, result);
            }
            return;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WatcherUtils.flattenModel(key + "." + i, Array.get(value, i), result);
            }
            return;
        }
        if (value instanceof ZonedDateTime) {
            result.put(key, WatcherDateTimeUtils.formatDate((ZonedDateTime)value));
            return;
        }
        if (value instanceof TimeValue) {
            result.put(key, String.valueOf(((TimeValue)value).getMillis()));
            return;
        }
        result.put(key, String.valueOf(value));
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty((CharSequence)id) && NO_WS_PATTERN.matcher(id).matches();
    }
}

