/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.core.security.support.Automatons;

class CertificateTrustRestrictions {
    private final Set<Predicate<String>> trustedNames;

    CertificateTrustRestrictions(Collection<String> trustedNames) {
        this.trustedNames = trustedNames.stream().map(xva$0 -> Automatons.predicate(xva$0)).collect(Collectors.toSet());
    }

    Set<Predicate<String>> getTrustedNames() {
        return Collections.unmodifiableSet(this.trustedNames);
    }

    public String toString() {
        return "{trustedNames=" + String.valueOf(this.trustedNames) + "}";
    }
}

