/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.action.admin.cluster.shards.TransportClusterSearchShardsAction;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.mapping.put.TransportAutoPutMappingAction;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexComponentSelectorPredicate;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class IndexPrivilege
extends Privilege {
    private static final Logger logger = LogManager.getLogger(IndexPrivilege.class);
    private static final Automaton ALL_AUTOMATON = Automatons.patterns("indices:*", "internal:transport/proxy/indices:*");
    private static final Automaton READ_AUTOMATON = Automatons.patterns("indices:data/read/*", "indices:admin/resolve/index", "indices:admin/resolve/cluster");
    private static final Automaton READ_FAILURE_STORE_AUTOMATON = Automatons.patterns("indices:data/read/*", "indices:admin/resolve/index");
    private static final Automaton READ_CROSS_CLUSTER_AUTOMATON = Automatons.patterns("internal:transport/proxy/indices:data/read/*", TransportClusterSearchShardsAction.TYPE.name(), TransportSearchShardsAction.TYPE.name(), "indices:admin/resolve/cluster", "indices:data/read/esql", "indices:data/read/esql/compute");
    private static final Automaton CREATE_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*", "indices:data/write/simulate/bulk*", "indices:data/write/otlp/*");
    private static final Automaton CREATE_DOC_AUTOMATON = Automatons.patterns("indices:data/write/index", "indices:data/write/index[*", "indices:data/write/index:op_type/create", "indices:data/write/bulk*", "indices:data/write/simulate/bulk*", "indices:data/write/otlp/*");
    private static final Automaton INDEX_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*", "indices:data/write/update*", "indices:data/write/simulate/bulk*", "indices:data/write/otlp/*");
    private static final Automaton DELETE_AUTOMATON = Automatons.patterns("indices:data/write/delete*", "indices:data/write/bulk*");
    private static final Automaton WRITE_AUTOMATON = Automatons.patterns("indices:data/write/*", TransportAutoPutMappingAction.TYPE.name());
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("indices:monitor/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.unionAndMinimize(Arrays.asList(MONITOR_AUTOMATON, Automatons.patterns("indices:admin/*", "indices:data/read/field_caps*", "indices:data/read/xpack/rollup/get/index/caps*")));
    private static final Automaton CREATE_INDEX_AUTOMATON = Automatons.patterns(TransportCreateIndexAction.TYPE.name(), "indices:admin/auto_create", "indices:admin/data_stream/create");
    private static final Automaton DELETE_INDEX_AUTOMATON = Automatons.patterns(TransportDeleteIndexAction.TYPE.name(), "indices:admin/data_stream/delete");
    private static final Automaton VIEW_METADATA_AUTOMATON = Automatons.patterns("indices:admin/aliases/get", "indices:admin/get", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get", TransportClusterSearchShardsAction.TYPE.name(), TransportSearchShardsAction.TYPE.name(), "indices:admin/validate/query*", "indices:monitor/settings/get", "indices:admin/ilm/explain", "indices:admin/data_stream/lifecycle/get", "indices:admin/data_stream/lifecycle/explain", "indices:admin/data_stream/get", "indices:admin/resolve/index", "indices:admin/resolve/cluster", "indices:data/read/field_caps*", "indices:data/read/xpack/rollup/get/index/caps*", "indices:monitor/transform/checkpoint*", "indices:monitor/get/metering/stats", "indices:admin/get/metering/stats");
    private static final Automaton MANAGE_FOLLOW_INDEX_AUTOMATON = Automatons.patterns("indices:admin/xpack/ccr/put_follow", "indices:admin/xpack/ccr/unfollow", "indices:admin/close*", "indices:admin/data_stream/promote", "indices:admin/rollover");
    private static final Automaton MANAGE_LEADER_INDEX_AUTOMATON = Automatons.patterns("indices:admin/xpack/ccr/forget_follower*");
    private static final Automaton MANAGE_ILM_AUTOMATON = Automatons.patterns("indices:admin/ilm/*");
    private static final Automaton MANAGE_DATA_STREAM_LIFECYCLE_AUTOMATON = Automatons.patterns("indices:admin/data_stream/lifecycle/*");
    private static final Automaton MAINTENANCE_AUTOMATON = Automatons.patterns("indices:admin/refresh*", "indices:admin/flush*", "indices:admin/synced_flush", "indices:admin/forcemerge*");
    private static final Automaton AUTO_CONFIGURE_AUTOMATON = Automatons.patterns(TransportAutoPutMappingAction.TYPE.name(), "indices:admin/auto_create");
    private static final Automaton CROSS_CLUSTER_REPLICATION_AUTOMATON = Automatons.patterns("indices:data/read/xpack/ccr/shard_changes*", "indices:monitor/stats*", RetentionLeaseActions.ADD.name() + "*", RetentionLeaseActions.REMOVE.name() + "*", RetentionLeaseActions.RENEW.name() + "*");
    private static final Automaton CROSS_CLUSTER_REPLICATION_INTERNAL_AUTOMATON = Automatons.patterns("indices:internal/admin/ccr/restore/session/clear*", "indices:internal/admin/ccr/restore/file_chunk/get*", "indices:internal/admin/ccr/restore/session/put*", "internal:transport/proxy/indices:internal/admin/ccr/restore/session/clear*", "internal:transport/proxy/indices:internal/admin/ccr/restore/file_chunk/get*");
    public static final IndexPrivilege NONE = new IndexPrivilege("none", Automatons.EMPTY);
    public static final IndexPrivilege ALL = new IndexPrivilege("all", ALL_AUTOMATON, IndexComponentSelectorPredicate.ALL);
    public static final IndexPrivilege READ = new IndexPrivilege("read", READ_AUTOMATON);
    public static final IndexPrivilege READ_CROSS_CLUSTER = new IndexPrivilege("read_cross_cluster", READ_CROSS_CLUSTER_AUTOMATON);
    public static final IndexPrivilege CREATE = new IndexPrivilege("create", CREATE_AUTOMATON);
    public static final IndexPrivilege INDEX = new IndexPrivilege("index", INDEX_AUTOMATON);
    public static final IndexPrivilege DELETE = new IndexPrivilege("delete", DELETE_AUTOMATON);
    public static final IndexPrivilege WRITE = new IndexPrivilege("write", WRITE_AUTOMATON);
    public static final IndexPrivilege CREATE_DOC = new IndexPrivilege("create_doc", CREATE_DOC_AUTOMATON);
    public static final IndexPrivilege MONITOR = new IndexPrivilege("monitor", MONITOR_AUTOMATON);
    public static final IndexPrivilege MANAGE = new IndexPrivilege("manage", MANAGE_AUTOMATON, IndexComponentSelectorPredicate.DATA_AND_FAILURES);
    public static final IndexPrivilege DELETE_INDEX = new IndexPrivilege("delete_index", DELETE_INDEX_AUTOMATON);
    public static final IndexPrivilege CREATE_INDEX = new IndexPrivilege("create_index", CREATE_INDEX_AUTOMATON);
    public static final IndexPrivilege VIEW_METADATA = new IndexPrivilege("view_index_metadata", VIEW_METADATA_AUTOMATON);
    public static final IndexPrivilege MANAGE_FOLLOW_INDEX = new IndexPrivilege("manage_follow_index", MANAGE_FOLLOW_INDEX_AUTOMATON);
    public static final IndexPrivilege MANAGE_LEADER_INDEX = new IndexPrivilege("manage_leader_index", MANAGE_LEADER_INDEX_AUTOMATON);
    public static final IndexPrivilege MANAGE_ILM = new IndexPrivilege("manage_ilm", MANAGE_ILM_AUTOMATON);
    public static final IndexPrivilege MANAGE_DATA_STREAM_LIFECYCLE = new IndexPrivilege("manage_data_stream_lifecycle", MANAGE_DATA_STREAM_LIFECYCLE_AUTOMATON, IndexComponentSelectorPredicate.DATA_AND_FAILURES);
    public static final IndexPrivilege MAINTENANCE = new IndexPrivilege("maintenance", MAINTENANCE_AUTOMATON);
    public static final IndexPrivilege AUTO_CONFIGURE = new IndexPrivilege("auto_configure", AUTO_CONFIGURE_AUTOMATON);
    public static final IndexPrivilege CROSS_CLUSTER_REPLICATION = new IndexPrivilege("cross_cluster_replication", CROSS_CLUSTER_REPLICATION_AUTOMATON);
    public static final IndexPrivilege CROSS_CLUSTER_REPLICATION_INTERNAL = new IndexPrivilege("cross_cluster_replication_internal", CROSS_CLUSTER_REPLICATION_INTERNAL_AUTOMATON);
    public static final IndexPrivilege READ_FAILURE_STORE = new IndexPrivilege("read_failure_store", READ_FAILURE_STORE_AUTOMATON, IndexComponentSelectorPredicate.FAILURES);
    public static final IndexPrivilege MANAGE_FAILURE_STORE = new IndexPrivilege("manage_failure_store", MANAGE_AUTOMATON, IndexComponentSelectorPredicate.FAILURES);
    private static final Map<String, IndexPrivilege> VALUES = IndexPrivilege.combineSortedInOrder(IndexPrivilege.sortByAccessLevel(Stream.of(Map.entry("read_failure_store", READ_FAILURE_STORE), Map.entry("manage_failure_store", MANAGE_FAILURE_STORE)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))), IndexPrivilege.sortByAccessLevel(Stream.of(Map.entry("none", NONE), Map.entry("all", ALL), Map.entry("manage", MANAGE), Map.entry("create_index", CREATE_INDEX), Map.entry("monitor", MONITOR), Map.entry("read", READ), Map.entry("index", INDEX), Map.entry("delete", DELETE), Map.entry("write", WRITE), Map.entry("create", CREATE), Map.entry("create_doc", CREATE_DOC), Map.entry("delete_index", DELETE_INDEX), Map.entry("view_index_metadata", VIEW_METADATA), Map.entry("read_cross_cluster", READ_CROSS_CLUSTER), Map.entry("manage_follow_index", MANAGE_FOLLOW_INDEX), Map.entry("manage_leader_index", MANAGE_LEADER_INDEX), Map.entry("manage_ilm", MANAGE_ILM), Map.entry("manage_data_stream_lifecycle", MANAGE_DATA_STREAM_LIFECYCLE), Map.entry("maintenance", MAINTENANCE), Map.entry("auto_configure", AUTO_CONFIGURE), Map.entry("cross_cluster_replication", CROSS_CLUSTER_REPLICATION), Map.entry("cross_cluster_replication_internal", CROSS_CLUSTER_REPLICATION_INTERNAL)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))));
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    public static final Predicate<String> CREATE_INDEX_MATCHER = CREATE_INDEX.predicate();
    private static final ConcurrentHashMap<Set<String>, Set<IndexPrivilege>> CACHE = new ConcurrentHashMap();
    private final IndexComponentSelectorPredicate selectorPredicate;

    private static Map<String, IndexPrivilege> combineSortedInOrder(SortedMap<String, IndexPrivilege> first, SortedMap<String, IndexPrivilege> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        LinkedHashMap<String, IndexPrivilege> combined = new LinkedHashMap<String, IndexPrivilege>(first);
        combined.putAll(second);
        return Collections.unmodifiableMap(combined);
    }

    private IndexPrivilege(String name, Automaton automaton) {
        this(Collections.singleton(name), automaton);
    }

    private IndexPrivilege(String name, Automaton automaton, IndexComponentSelectorPredicate selectorPredicate) {
        this(Collections.singleton(name), automaton, selectorPredicate);
    }

    private IndexPrivilege(Set<String> name, Automaton automaton) {
        this(name, automaton, IndexComponentSelectorPredicate.DATA);
    }

    private IndexPrivilege(Set<String> name, Automaton automaton, IndexComponentSelectorPredicate selectorPredicate) {
        super(name, automaton);
        this.selectorPredicate = selectorPredicate;
    }

    public static IndexPrivilege get(String actionOrPrivilege) {
        Set<IndexPrivilege> privilegeSingleton = IndexPrivilege.resolveBySelectorAccess(Set.of(actionOrPrivilege));
        if (privilegeSingleton.size() != 1) {
            throw new IllegalArgumentException("index privilege name or action " + actionOrPrivilege + " must map to exactly one privilege but mapped to " + String.valueOf(privilegeSingleton));
        }
        return privilegeSingleton.iterator().next();
    }

    public static Set<IndexPrivilege> resolveBySelectorAccess(Set<String> names) {
        return CACHE.computeIfAbsent(names, theName -> {
            if (theName.isEmpty()) {
                return Set.of(NONE);
            }
            return IndexPrivilege.resolve(theName);
        });
    }

    @Nullable
    public static IndexPrivilege getNamedOrNull(String name) {
        return VALUES.get(name.toLowerCase(Locale.ROOT));
    }

    private static Set<IndexPrivilege> resolve(Set<String> name) {
        int size = name.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<IndexPrivilege> allSelectorAccessPrivileges = new HashSet<IndexPrivilege>();
        HashSet<IndexPrivilege> dataSelectorAccessPrivileges = new HashSet<IndexPrivilege>();
        HashSet<IndexPrivilege> failuresSelectorAccessPrivileges = new HashSet<IndexPrivilege>();
        HashSet<IndexPrivilege> dataAndFailuresSelectorAccessPrivileges = new HashSet<IndexPrivilege>();
        boolean containsAllAccessPrivilege = name.stream().anyMatch(n -> IndexPrivilege.getNamedOrNull(n) == ALL);
        for (String part : name) {
            IndexPrivilege indexPrivilege;
            if (ACTION_MATCHER.test(part = part.toLowerCase(Locale.ROOT))) {
                actions.add(part);
                continue;
            }
            IndexPrivilege indexPrivilege2 = indexPrivilege = part == null ? null : VALUES.get(part);
            if (indexPrivilege != null && size == 1) {
                return Set.of(indexPrivilege);
            }
            if (indexPrivilege != null) {
                if (containsAllAccessPrivilege) {
                    allSelectorAccessPrivileges.add(indexPrivilege);
                    continue;
                }
                if (indexPrivilege.selectorPredicate == IndexComponentSelectorPredicate.DATA) {
                    dataSelectorAccessPrivileges.add(indexPrivilege);
                    continue;
                }
                if (indexPrivilege.selectorPredicate == IndexComponentSelectorPredicate.FAILURES) {
                    failuresSelectorAccessPrivileges.add(indexPrivilege);
                    continue;
                }
                if (indexPrivilege.selectorPredicate == IndexComponentSelectorPredicate.DATA_AND_FAILURES) {
                    dataAndFailuresSelectorAccessPrivileges.add(indexPrivilege);
                    continue;
                }
                String errorMessage = "unexpected selector [" + String.valueOf(indexPrivilege.selectorPredicate) + "]";
                assert (false) : errorMessage;
                throw new IllegalStateException(errorMessage);
            }
            String errorMessage = "unknown index privilege [" + part + "]. a privilege must be either one of the predefined fixed indices privileges [" + Strings.collectionToCommaDelimitedString((Iterable)IndexPrivilege.names().stream().sorted().collect(Collectors.toList())) + "] or a pattern over one of the available index actions";
            logger.debug(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Set<IndexPrivilege> combined = IndexPrivilege.combineIndexPrivileges(allSelectorAccessPrivileges, dataSelectorAccessPrivileges, failuresSelectorAccessPrivileges, dataAndFailuresSelectorAccessPrivileges, actions);
        IndexPrivilege.assertNamesMatch(name, combined);
        return Collections.unmodifiableSet(combined);
    }

    private static Set<IndexPrivilege> combineIndexPrivileges(Set<IndexPrivilege> allSelectorAccessPrivileges, Set<IndexPrivilege> dataSelectorAccessPrivileges, Set<IndexPrivilege> failuresSelectorAccessPrivileges, Set<IndexPrivilege> dataAndFailuresSelectorAccessPrivileges, Set<String> actions) {
        assert (!(allSelectorAccessPrivileges.isEmpty() && dataSelectorAccessPrivileges.isEmpty() && failuresSelectorAccessPrivileges.isEmpty() && dataAndFailuresSelectorAccessPrivileges.isEmpty() && actions.isEmpty())) : "at least one of the privilege sets or actions must be non-empty";
        if (!allSelectorAccessPrivileges.isEmpty()) {
            assert (failuresSelectorAccessPrivileges.isEmpty() && dataSelectorAccessPrivileges.isEmpty() && dataAndFailuresSelectorAccessPrivileges.isEmpty()) : "data and failure access must be empty when all access is present";
            return Set.of(IndexPrivilege.union(allSelectorAccessPrivileges, actions, IndexComponentSelectorPredicate.ALL));
        }
        LinkedHashSet combined = Sets.newLinkedHashSetWithExpectedSize((int)(dataAndFailuresSelectorAccessPrivileges.size() + failuresSelectorAccessPrivileges.size() + dataSelectorAccessPrivileges.size() + actions.size()));
        if (!dataSelectorAccessPrivileges.isEmpty() || !actions.isEmpty()) {
            combined.add(IndexPrivilege.union(dataSelectorAccessPrivileges, actions, IndexComponentSelectorPredicate.DATA));
        }
        if (!dataAndFailuresSelectorAccessPrivileges.isEmpty()) {
            combined.add(IndexPrivilege.union(dataAndFailuresSelectorAccessPrivileges, Set.of(), IndexComponentSelectorPredicate.DATA_AND_FAILURES));
        }
        if (!failuresSelectorAccessPrivileges.isEmpty()) {
            combined.add(IndexPrivilege.union(failuresSelectorAccessPrivileges, Set.of(), IndexComponentSelectorPredicate.FAILURES));
        }
        return combined;
    }

    private static void assertNamesMatch(Set<String> names, Set<IndexPrivilege> privileges) {
        assert (names.stream().map(n -> n.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()).equals(privileges.stream().map(Privilege::name).flatMap(Collection::stream).collect(Collectors.toSet()))) : "mismatch between names [" + String.valueOf(names) + "] and names on split privileges [" + String.valueOf(privileges) + "]";
    }

    private static IndexPrivilege union(Collection<IndexPrivilege> privileges, Collection<String> actions, IndexComponentSelectorPredicate selectorPredicate) {
        HashSet automata = Sets.newHashSetWithExpectedSize((int)(privileges.size() + actions.size()));
        HashSet names = Sets.newHashSetWithExpectedSize((int)(privileges.size() + actions.size()));
        for (IndexPrivilege privilege : privileges) {
            names.addAll(privilege.name());
            automata.add(privilege.automaton);
        }
        if (!actions.isEmpty()) {
            names.addAll(actions);
            automata.add(Automatons.patterns(actions.stream().map(Privilege::actionToPattern).toList()));
        }
        return new IndexPrivilege((Set<String>)names, Automatons.unionAndMinimize(automata), selectorPredicate);
    }

    static Map<String, IndexPrivilege> values() {
        return VALUES;
    }

    public static Set<String> names() {
        return Collections.unmodifiableSet(VALUES.keySet());
    }

    public static Collection<String> findPrivilegesThatGrant(String action) {
        return IndexPrivilege.findPrivilegesThatGrant(action, p -> p.getSelectorPredicate().test(IndexComponentSelector.DATA));
    }

    public static Collection<String> findPrivilegesThatGrant(String action, Predicate<IndexPrivilege> preCondition) {
        return VALUES.entrySet().stream().filter(e -> preCondition.test((IndexPrivilege)e.getValue())).filter(e -> ((IndexPrivilege)e.getValue()).predicate.test(action)).map(Map.Entry::getKey).toList();
    }

    public IndexComponentSelectorPredicate getSelectorPredicate() {
        return this.selectorPredicate;
    }
}

