/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class BulkPutRoleRequestBuilder
extends ActionRequestBuilder<BulkPutRolesRequest, BulkRolesResponse> {
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowDescription(true).build();
    private static final ConstructingObjectParser<List<RoleDescriptor>, Void> PARSER = new ConstructingObjectParser("bulk_update_roles_request_payload", a -> (List)a[0]);

    public BulkPutRoleRequestBuilder(ElasticsearchClient client) {
        super(client, ActionTypes.BULK_PUT_ROLES, (ActionRequest)new BulkPutRolesRequest(List.of()));
    }

    public BulkPutRoleRequestBuilder content(BytesReference content, XContentType xContentType) throws IOException {
        XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)content, (XContentType)xContentType);
        List roles = (List)PARSER.parse(parser, null);
        ((BulkPutRolesRequest)this.request).setRoles(roles);
        return this;
    }

    public BulkPutRoleRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        ((BulkPutRolesRequest)this.request).setRefreshPolicy(refreshPolicy);
        return this;
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return ROLE_DESCRIPTOR_PARSER.parse(n, p, false);
        }, new ParseField("roles", new String[0]));
    }
}

