/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding;

import java.nio.charset.StandardCharsets;

final class Hash32 {
    private static final int DEFAULT_SEED = 48879;
    private final int seed;

    Hash32(int seed) {
        this.seed = seed;
    }

    Hash32() {
        this(48879);
    }

    public long hash(String input) {
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        return Integer.toUnsignedLong(this.hash32(bytes));
    }

    private int hash32(byte[] data) {
        int n;
        int m = 1540483477;
        int r = 24;
        int h = this.seed ^ n;
        int i = 0;
        for (n = data.length; n >= 4; n -= 4) {
            int k = Hash32.decodeFixed32(data, i);
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
            i += 4;
        }
        if (n == 3) {
            h ^= Byte.toUnsignedInt(data[i + 2]) << 16;
        }
        if (n >= 2) {
            h ^= Byte.toUnsignedInt(data[i + 1]) << 8;
        }
        if (n >= 1) {
            h ^= Byte.toUnsignedInt(data[i]);
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    private static int decodeFixed32(byte[] ptr, int offset) {
        return Byte.toUnsignedInt(ptr[offset]) | Byte.toUnsignedInt(ptr[offset + 1]) << 8 | Byte.toUnsignedInt(ptr[offset + 2]) << 16 | Byte.toUnsignedInt(ptr[offset + 3]) << 24;
    }
}

