/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RoutingStateAndReason
implements ToXContentObject,
Writeable {
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField ROUTING_STATE = new ParseField("routing_state", new String[0]);
    private static final ConstructingObjectParser<RoutingStateAndReason, Void> PARSER = new ConstructingObjectParser("trained_model_routing_state", a -> new RoutingStateAndReason(RoutingState.fromString((String)a[0]), (String)a[1]));
    private final String reason;
    private final RoutingState state;

    public static RoutingStateAndReason fromXContent(XContentParser parser) {
        return (RoutingStateAndReason)PARSER.apply(parser, null);
    }

    public RoutingStateAndReason(RoutingState state, String reason) {
        this.state = ExceptionsHelper.requireNonNull(state, ROUTING_STATE);
        this.reason = reason;
    }

    public RoutingStateAndReason(StreamInput in) throws IOException {
        this.state = (RoutingState)in.readEnum(RoutingState.class);
        this.reason = in.readOptionalString();
    }

    public String getReason() {
        return this.reason;
    }

    public RoutingState getState() {
        return this.state;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.state);
        out.writeOptionalString(this.reason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ROUTING_STATE.getPreferredName(), (Enum)this.state);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingStateAndReason that = (RoutingStateAndReason)o;
        return Objects.equals(this.reason, that.reason) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.state);
    }

    public String toString() {
        return "RoutingStateAndReason{reason='" + this.reason + "', state=" + String.valueOf(this.state) + "}";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ROUTING_STATE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
    }
}

