/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.usage;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SemanticTextStats
implements ToXContentObject,
Writeable {
    private static final String FIELD_COUNT = "field_count";
    private static final String INDICES_COUNT = "indices_count";
    private static final String INFERENCE_ID_COUNT = "inference_id_count";
    private long fieldCount;
    private long indicesCount;
    private long inferenceIdCount;

    public SemanticTextStats() {
    }

    public SemanticTextStats(long fieldCount, long indicesCount, long inferenceIdCount) {
        this.fieldCount = fieldCount;
        this.indicesCount = indicesCount;
        this.inferenceIdCount = inferenceIdCount;
    }

    public SemanticTextStats(StreamInput in) throws IOException {
        this.fieldCount = in.readVLong();
        this.indicesCount = in.readVLong();
        this.inferenceIdCount = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fieldCount);
        out.writeVLong(this.indicesCount);
        out.writeVLong(this.inferenceIdCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_COUNT, this.fieldCount);
        builder.field(INDICES_COUNT, this.indicesCount);
        builder.field(INFERENCE_ID_COUNT, this.inferenceIdCount);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticTextStats that = (SemanticTextStats)o;
        return this.fieldCount == that.fieldCount && this.indicesCount == that.indicesCount && this.inferenceIdCount == that.inferenceIdCount;
    }

    public int hashCode() {
        return Objects.hash(this.fieldCount, this.indicesCount, this.inferenceIdCount);
    }

    public long getFieldCount() {
        return this.fieldCount;
    }

    public long getIndicesCount() {
        return this.indicesCount;
    }

    public long getInferenceIdCount() {
        return this.inferenceIdCount;
    }

    public void addFieldCount(long fieldCount) {
        this.fieldCount += fieldCount;
    }

    public void incIndicesCount() {
        ++this.indicesCount;
    }

    public void setInferenceIdCount(long inferenceIdCount) {
        this.inferenceIdCount = inferenceIdCount;
    }

    public boolean isEmpty() {
        return this.fieldCount == 0L && this.indicesCount == 0L && this.inferenceIdCount == 0L;
    }
}

