/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.inference.usage.ModelStats;

public class InferenceFeatureSetUsage
extends XPackFeatureUsage {
    public static final InferenceFeatureSetUsage EMPTY = new InferenceFeatureSetUsage(List.of());
    private final Collection<ModelStats> modelStats;

    public InferenceFeatureSetUsage(Collection<ModelStats> modelStats) {
        super("inference", true, true);
        this.modelStats = modelStats;
    }

    public InferenceFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.modelStats = in.readCollectionAsList(ModelStats::new);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.xContentList("models", this.modelStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.modelStats);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceFeatureSetUsage that = (InferenceFeatureSetUsage)o;
        return Objects.equals(this.modelStats, that.modelStats);
    }

    public int hashCode() {
        return Objects.hashCode(this.modelStats);
    }

    Collection<ModelStats> modelStats() {
        return this.modelStats;
    }
}

