/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.resources.TemplateResources;

public class LifecyclePolicyUtils {
    private LifecyclePolicyUtils() {
    }

    public static LifecyclePolicy loadPolicy(String name, String resource, Map<String, String> variables, NamedXContentRegistry xContentRegistry) {
        try {
            String source = TemplateResources.load((String)resource);
            source = LifecyclePolicyUtils.replaceVariables(source, variables);
            LifecyclePolicyUtils.validate(source);
            return LifecyclePolicyUtils.parsePolicy(source, name, xContentRegistry, XContentType.JSON);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to load policy [" + name + "] from [" + resource + "]", e);
        }
    }

    public static LifecyclePolicy parsePolicy(String rawPolicy, String name, NamedXContentRegistry xContentRegistry, XContentType contentType) throws IOException {
        try (XContentParser parser = contentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry), rawPolicy);){
            LifecyclePolicy policy = LifecyclePolicy.parse(parser, name);
            policy.validate();
            LifecyclePolicy lifecyclePolicy = policy;
            return lifecyclePolicy;
        }
    }

    private static String replaceVariables(String template, Map<String, String> variables) {
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            template = LifecyclePolicyUtils.replaceVariable(template, variable.getKey(), variable.getValue());
        }
        return template;
    }

    public static String replaceVariable(String input, String variable, String value) {
        return input.replace("${" + variable + "}", value);
    }

    private static void validate(String source) {
        if (source == null) {
            throw new ElasticsearchParseException("policy must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((BytesReference)new BytesArray(source), (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("policy must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("invalid policy", (Throwable)e, new Object[0]);
        }
    }
}

