/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupGeneratedIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-generated-index";
    private static final Logger logger = LogManager.getLogger(CleanupGeneratedIndexStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public CleanupGeneratedIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier) {
        super(key, nextStepKey, client);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ProjectMetadata currentProject, final ActionListener<Void> listener) {
        String generatedIndexSource = (String)IndexMetadata.INDEX_RESIZE_SOURCE_NAME.get(indexMetadata.getSettings());
        if (Strings.hasText((String)generatedIndexSource) && currentProject.index(generatedIndexSource) == null) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            logger.warn("managed index [{}] as part of policy [{}] is a shrunk index and the source index [{}] does not exist anymore. will skip the [{}] step", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)generatedIndexSource, (Object)NAME);
            listener.onResponse(null);
            return;
        }
        String targetIndexName = this.targetIndexNameSupplier.apply(indexMetadata.getIndex().getName(), indexMetadata.getLifecycleExecutionState());
        if (!Strings.hasText((String)targetIndexName)) {
            listener.onResponse(null);
            return;
        }
        this.getClient(currentProject.id()).admin().indices().delete((DeleteIndexRequest)new DeleteIndexRequest(targetIndexName).masterNodeTimeout(TimeValue.MAX_VALUE), (ActionListener)new ActionListener<AcknowledgedResponse>(this){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    public BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }
}

