/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;

public class GetEnrichPolicyAction
extends ActionType<Response> {
    public static final GetEnrichPolicyAction INSTANCE = new GetEnrichPolicyAction();
    public static final String NAME = "cluster:admin/xpack/enrich/get";

    private GetEnrichPolicyAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<EnrichPolicy.NamedPolicy> policies;

        public Response(Map<String, EnrichPolicy> policies) {
            Objects.requireNonNull(policies, "policies cannot be null");
            this.policies = new TreeMap<String, EnrichPolicy>(policies).entrySet().stream().map(entry -> new EnrichPolicy.NamedPolicy((String)entry.getKey(), (EnrichPolicy)entry.getValue())).collect(Collectors.toList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.policies);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("policies");
            for (EnrichPolicy.NamedPolicy policy : this.policies) {
                builder.startObject();
                builder.startObject("config");
                policy.toXContent(builder, params);
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public List<EnrichPolicy.NamedPolicy> getPolicies() {
            return this.policies;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.policies.equals(response.policies);
        }

        public int hashCode() {
            return Objects.hash(this.policies);
        }
    }

    public static class Request
    extends LocalClusterStateRequest {
        private final List<String> names;

        public Request(TimeValue masterNodeTimeout, String ... names) {
            super(masterNodeTimeout);
            this.names = List.of(names);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringCollectionAsImmutableList();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public List<String> getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.names, request.names);
        }

        public int hashCode() {
            return Objects.hash(this.names);
        }
    }
}

