/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;

public record DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus downsampleShardIndexerStatus, BytesRef tsid) implements PersistentTaskState
{
    public static final String NAME = "rollup-shard";
    private static final ParseField ROLLUP_SHARD_INDEXER_STATUS = new ParseField("status", new String[0]);
    private static final ParseField TSID = new ParseField("tsid", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("rollup-shard");

    public DownsampleShardPersistentTaskState(StreamInput in) throws IOException {
        this(DownsampleShardIndexerStatus.readFromStream(in), in.readBytesRef());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ROLLUP_SHARD_INDEXER_STATUS.getPreferredName(), (Enum)this.downsampleShardIndexerStatus);
        if (this.tsid != null) {
            builder.field(TSID.getPreferredName(), this.tsid.utf8ToString());
        }
        return builder.endObject();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.downsampleShardIndexerStatus.writeTo(out);
        out.writeBytesRef(this.tsid);
    }

    public boolean done() {
        return DownsampleShardIndexerStatus.COMPLETED.equals((Object)this.downsampleShardIndexerStatus) || DownsampleShardIndexerStatus.CANCELLED.equals((Object)this.downsampleShardIndexerStatus) || DownsampleShardIndexerStatus.FAILED.equals((Object)this.downsampleShardIndexerStatus);
    }

    public boolean started() {
        return DownsampleShardIndexerStatus.STARTED.equals((Object)this.downsampleShardIndexerStatus);
    }

    public boolean cancelled() {
        return DownsampleShardIndexerStatus.CANCELLED.equals((Object)this.downsampleShardIndexerStatus);
    }

    public boolean failed() {
        return DownsampleShardIndexerStatus.FAILED.equals((Object)this.downsampleShardIndexerStatus);
    }

    public static DownsampleShardPersistentTaskState readFromStream(StreamInput in) throws IOException {
        return new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.readFromStream(in), in.readBytesRef());
    }

    public static DownsampleShardPersistentTaskState fromXContent(XContentParser parser) throws IOException {
        Builder builder = new Builder();
        PARSER.parse(parser, (Object)builder, null);
        return builder.build();
    }

    static {
        PARSER.declareField(Builder::status, (p, c) -> DownsampleShardIndexerStatus.valueOf(p.textOrNull()), ROLLUP_SHARD_INDEXER_STATUS, ObjectParser.ValueType.STRING);
        PARSER.declareField(Builder::tsid, (p, c) -> new BytesRef((CharSequence)p.textOrNull()), TSID, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private DownsampleShardIndexerStatus status;
        private BytesRef tsid;

        public Builder status(DownsampleShardIndexerStatus status) {
            this.status = status;
            return this;
        }

        public Builder tsid(BytesRef tsid) {
            this.tsid = tsid;
            return this;
        }

        public DownsampleShardPersistentTaskState build() {
            return new DownsampleShardPersistentTaskState(this.status, this.tsid);
        }
    }
}

