/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public record RepositoryVerifyIntegrityParams(String repository, int metaThreadPoolConcurrency, int blobThreadPoolConcurrency, int snapshotVerificationConcurrency, int indexVerificationConcurrency, int indexSnapshotVerificationConcurrency, int maxFailedShardSnapshots, boolean verifyBlobContents, ByteSizeValue maxBytesPerSec) implements Writeable
{
    public static final String MAX_FAILED_SHARD_SNAPSHOTS = "max_failed_shard_snapshots";

    public RepositoryVerifyIntegrityParams {
        Objects.requireNonNull(repository, "repository");
        RepositoryVerifyIntegrityParams.requireNonNegative("meta_thread_pool_concurrency", metaThreadPoolConcurrency);
        RepositoryVerifyIntegrityParams.requireNonNegative("blob_thread_pool_concurrency", blobThreadPoolConcurrency);
        RepositoryVerifyIntegrityParams.requireNonNegative("snapshot_verification_concurrency", snapshotVerificationConcurrency);
        RepositoryVerifyIntegrityParams.requireNonNegative("index_verification_concurrency", indexVerificationConcurrency);
        RepositoryVerifyIntegrityParams.requireNonNegative("index_snapshot_verification_concurrency", indexSnapshotVerificationConcurrency);
        RepositoryVerifyIntegrityParams.requireNonNegative(MAX_FAILED_SHARD_SNAPSHOTS, maxFailedShardSnapshots);
        if (maxBytesPerSec.getBytes() < 1L) {
            throw new IllegalArgumentException("invalid rate limit");
        }
    }

    RepositoryVerifyIntegrityParams(RestRequest restRequest) {
        this(restRequest.param("repository"), restRequest.paramAsInt("meta_thread_pool_concurrency", 0), restRequest.paramAsInt("blob_thread_pool_concurrency", 0), restRequest.paramAsInt("snapshot_verification_concurrency", 0), restRequest.paramAsInt("index_verification_concurrency", 0), restRequest.paramAsInt("index_snapshot_verification_concurrency", 0), restRequest.paramAsInt(MAX_FAILED_SHARD_SNAPSHOTS, 0), restRequest.paramAsBoolean("verify_blob_contents", false), restRequest.paramAsSize("max_bytes_per_sec", ByteSizeValue.ofMb((long)40L)));
    }

    RepositoryVerifyIntegrityParams(StreamInput in) throws IOException {
        this(in.readString(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readBoolean(), ByteSizeValue.readFrom((StreamInput)in));
    }

    private static void requireNonNegative(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("argument [" + name + "] must be at least [0]");
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.repository);
        out.writeVInt(this.metaThreadPoolConcurrency);
        out.writeVInt(this.blobThreadPoolConcurrency);
        out.writeVInt(this.snapshotVerificationConcurrency);
        out.writeVInt(this.indexVerificationConcurrency);
        out.writeVInt(this.indexSnapshotVerificationConcurrency);
        out.writeVInt(this.maxFailedShardSnapshots);
        out.writeBoolean(this.verifyBlobContents);
        this.maxBytesPerSec.writeTo(out);
    }

    public RepositoryVerifyIntegrityParams withResolvedDefaults(ThreadPool.Info metadataThreadPoolInfo) {
        if (this.metaThreadPoolConcurrency > 0 && this.blobThreadPoolConcurrency > 0 && this.snapshotVerificationConcurrency > 0 && this.indexVerificationConcurrency > 0 && this.indexSnapshotVerificationConcurrency > 0 && this.maxFailedShardSnapshots > 0) {
            return this;
        }
        int maxThreads = Math.max(1, metadataThreadPoolInfo.getMax());
        int halfMaxThreads = Math.max(1, maxThreads / 2);
        return new RepositoryVerifyIntegrityParams(this.repository, this.metaThreadPoolConcurrency > 0 ? this.metaThreadPoolConcurrency : halfMaxThreads, this.blobThreadPoolConcurrency > 0 ? this.blobThreadPoolConcurrency : 1, this.snapshotVerificationConcurrency > 0 ? this.snapshotVerificationConcurrency : halfMaxThreads, this.indexVerificationConcurrency > 0 ? this.indexVerificationConcurrency : maxThreads, this.indexSnapshotVerificationConcurrency > 0 ? this.indexSnapshotVerificationConcurrency : 1, this.maxFailedShardSnapshots > 0 ? this.maxFailedShardSnapshots : 10000, this.verifyBlobContents, this.maxBytesPerSec);
    }
}

