/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringUtils;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.util.Check;

public class BetweenFunctionProcessor
implements Processor {
    public static final String NAME = "sbtw";
    private final Processor input;
    private final Processor left;
    private final Processor right;
    private final Processor greedy;
    private final boolean caseInsensitive;

    public BetweenFunctionProcessor(Processor input, Processor left, Processor right, Processor greedy, boolean caseInsensitive) {
        this.input = input;
        this.left = left;
        this.right = right;
        this.greedy = greedy;
        this.caseInsensitive = caseInsensitive;
    }

    public BetweenFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.left = (Processor)in.readNamedWriteable(Processor.class);
        this.right = (Processor)in.readNamedWriteable(Processor.class);
        this.greedy = (Processor)in.readNamedWriteable(Processor.class);
        this.caseInsensitive = in.readBoolean();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.left);
        out.writeNamedWriteable((NamedWriteable)this.right);
        out.writeNamedWriteable((NamedWriteable)this.greedy);
        out.writeBoolean(this.caseInsensitive);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object process(Object o) {
        return BetweenFunctionProcessor.doProcess(this.input.process(o), this.left.process(o), this.right.process(o), this.greedy.process(o), this.caseInsensitive);
    }

    public static Object doProcess(Object input, Object left, Object right, Object greedy, Boolean caseInsensitive) {
        if (input == null) {
            return null;
        }
        Check.isString((Object)input);
        Check.isString((Object)left);
        Check.isString((Object)right);
        Check.isBoolean((Object)greedy);
        Check.isBoolean((Object)caseInsensitive);
        String str = input.toString();
        String strRight = right.toString();
        String strLeft = left.toString();
        boolean bGreedy = (Boolean)greedy;
        return StringUtils.between(str, strLeft, strRight, bGreedy, caseInsensitive);
    }

    protected Processor input() {
        return this.input;
    }

    public Processor left() {
        return this.left;
    }

    public Processor right() {
        return this.right;
    }

    public Processor greedy() {
        return this.greedy;
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.left(), this.right(), this.greedy(), this.caseInsensitive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BetweenFunctionProcessor other = (BetweenFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right()) && Objects.equals(this.greedy(), other.greedy()) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }
}

