/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison;

import java.time.ZoneId;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public abstract class BinaryComparison
extends BinaryOperator<Object, Object, Boolean, BinaryComparisonOperation> {
    private final ZoneId zoneId;

    protected BinaryComparison(Source source, Expression left, Expression right, BinaryComparisonOperation operation, ZoneId zoneId) {
        super(source, left, right, operation);
        this.zoneId = zoneId;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isExact(e, this.sourceText(), paramOrdinal);
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public static Integer compare(Object left, Object right) {
        return Comparisons.compare(left, right);
    }

    public abstract BinaryComparison reverse();
}

