/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

@ServerlessScope(value=Scope.PUBLIC)
public class RestInferTrainedModelAction
extends BaseRestHandler {
    static final String PATH = "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}/_infer";

    public String getName() {
        return "xpack_ml_infer_trained_models_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, PATH));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        InferModelAction.Request.Builder request;
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (!restRequest.hasContent()) {
            throw ExceptionsHelper.badRequestException((String)"requires body", (Object[])new Object[0]);
        }
        try (XContentParser parser = restRequest.contentParser();){
            request = InferModelAction.Request.parseRequest((String)modelId, (XContentParser)parser);
        }
        if (restRequest.hasParam(InferModelAction.Request.TIMEOUT.getPreferredName())) {
            TimeValue inferTimeout = restRequest.paramAsTime(InferModelAction.Request.TIMEOUT.getPreferredName(), InferModelAction.Request.DEFAULT_TIMEOUT_FOR_API);
            request.setInferenceTimeout(inferTimeout);
        }
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)InferModelAction.EXTERNAL_INSTANCE, (ActionRequest)request.build(), (ActionListener)new RestToXContentListener(channel));
    }
}

