/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetTrainedModelsAction
extends BaseRestHandler {
    private static final Map<String, String> DEFAULT_TO_XCONTENT_VALUES = Collections.singletonMap("decompress_definition", Boolean.toString(true));

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ml/trained_models/{" + String.valueOf(TrainedModelConfig.MODEL_ID) + "}"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/trained_models"));
    }

    public String getName() {
        return "ml_get_trained_models_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)modelId)) {
            modelId = "_all";
        }
        List<String> tags = Arrays.asList(restRequest.paramAsStringArray(TrainedModelConfig.TAGS.getPreferredName(), Strings.EMPTY_ARRAY));
        HashSet<String> includes = new HashSet<String>(Arrays.asList(restRequest.paramAsStringArray(GetTrainedModelsAction.Request.INCLUDE.getPreferredName(), Strings.EMPTY_ARRAY)));
        GetTrainedModelsAction.Request request = new GetTrainedModelsAction.Request(modelId, tags, includes);
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        request.setAllowNoResources(restRequest.paramAsBoolean(GetTrainedModelsAction.Request.ALLOW_NO_MATCH.getPreferredName(), request.isAllowNoResources()));
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)request, new RestToXContentListenerWithDefaultValues((RestChannel)channel, DEFAULT_TO_XCONTENT_VALUES, (Set<String>)includes));
    }

    protected Set<String> responseParams() {
        return Set.of("decompress_definition", "exclude_generated");
    }

    private static class RestToXContentListenerWithDefaultValues<T extends ToXContentObject>
    extends RestToXContentListener<T> {
        private final Map<String, String> defaultToXContentParamValues;
        private final Set<String> includes;

        private RestToXContentListenerWithDefaultValues(RestChannel channel, Map<String, String> defaultToXContentParamValues, Set<String> includes) {
            super(channel);
            this.defaultToXContentParamValues = defaultToXContentParamValues;
            this.includes = includes;
        }

        public RestResponse buildResponse(T response, XContentBuilder builder) throws Exception {
            assert (!response.isFragment());
            HashMap<String, String> params = new HashMap<String, String>(this.channel.request().params());
            this.defaultToXContentParamValues.forEach((k, v) -> params.computeIfAbsent((String)k, this.defaultToXContentParamValues::get));
            this.includes.forEach(include -> params.put((String)include, "true"));
            params.put("for_internal_storage", "false");
            response.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(params));
            return new RestResponse((RestStatus)this.statusFunction.apply(response), builder);
        }
    }
}

