/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.diagnostics;

import java.util.Date;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.utils.Intervals;

class BucketDiagnostics {
    private static final int MIN_BUCKETS = 10;
    private final long bucketSpanMs;
    private final long latencyMs;
    private final int maxSize;
    private final long[] buckets;
    private long movingBucketCount = 0L;
    private long latestBucketStartMs = -1L;
    private int latestBucketIndex;
    private long earliestBucketStartMs = -1L;
    private int earliestBucketIndex;
    private long latestFlushedBucketStartMs = -1L;
    private final BucketFlushListener bucketFlushListener;

    BucketDiagnostics(Job job, DataCounts dataCounts, BucketFlushListener bucketFlushListener) {
        this.bucketSpanMs = job.getAnalysisConfig().getBucketSpan().millis();
        this.latencyMs = job.getAnalysisConfig().getLatency() == null ? 0L : job.getAnalysisConfig().getLatency().millis();
        this.maxSize = Math.max((int)(Intervals.alignToCeil((long)this.latencyMs, (long)this.bucketSpanMs) / this.bucketSpanMs), 10);
        this.buckets = new long[this.maxSize];
        this.bucketFlushListener = bucketFlushListener;
        Date latestRecordTimestamp = dataCounts.getLatestRecordTimeStamp();
        if (latestRecordTimestamp != null) {
            this.addRecord(latestRecordTimestamp.getTime());
        }
    }

    void addRecord(long recordTimestampMs) {
        long bucketStartMs = Intervals.alignToFloor((long)recordTimestampMs, (long)this.bucketSpanMs);
        if (this.latestBucketStartMs < 0L) {
            this.latestBucketStartMs = bucketStartMs;
            this.earliestBucketStartMs = bucketStartMs;
        }
        this.advanceTime(bucketStartMs);
        this.addToBucket(bucketStartMs);
    }

    private void advanceTime(long bucketStartMs) {
        while (bucketStartMs > this.latestBucketStartMs) {
            int flushBucketIndex = (this.latestBucketIndex + 1) % this.maxSize;
            if (flushBucketIndex == this.earliestBucketIndex) {
                this.flush(flushBucketIndex);
                this.movingBucketCount -= this.buckets[flushBucketIndex];
                this.earliestBucketStartMs += this.bucketSpanMs;
                this.earliestBucketIndex = (this.earliestBucketIndex + 1) % this.maxSize;
            }
            this.buckets[flushBucketIndex] = 0L;
            this.latestBucketStartMs += this.bucketSpanMs;
            this.latestBucketIndex = flushBucketIndex;
        }
    }

    private void addToBucket(long bucketStartMs) {
        int offsetToLatest = (int)((bucketStartMs - this.latestBucketStartMs) / this.bucketSpanMs);
        int bucketIndex = (this.latestBucketIndex + offsetToLatest) % this.maxSize;
        if (bucketIndex < 0) {
            bucketIndex = this.maxSize + bucketIndex;
        }
        int n = bucketIndex;
        this.buckets[n] = this.buckets[n] + 1L;
        ++this.movingBucketCount;
        if (bucketStartMs < this.earliestBucketStartMs) {
            this.earliestBucketStartMs = bucketStartMs;
            this.earliestBucketIndex = bucketIndex;
        }
    }

    private void flush(int bucketIndex) {
        long bucketStartMs = this.getTimestampMs(bucketIndex);
        if (bucketStartMs > this.latestFlushedBucketStartMs) {
            this.bucketFlushListener.onBucketFlush(bucketStartMs, this.buckets[bucketIndex]);
            this.latestFlushedBucketStartMs = bucketStartMs;
        }
    }

    private long getTimestampMs(int bucketIndex) {
        int offsetToLatest = this.latestBucketIndex - bucketIndex;
        if (offsetToLatest < 0) {
            offsetToLatest = this.maxSize + offsetToLatest;
        }
        return this.latestBucketStartMs - (long)offsetToLatest * this.bucketSpanMs;
    }

    void flush() {
        if (this.latestBucketStartMs < 0L) {
            return;
        }
        int bucketIndex = this.earliestBucketIndex;
        while (bucketIndex != this.latestBucketIndex) {
            this.flush(bucketIndex);
            bucketIndex = (bucketIndex + 1) % this.maxSize;
        }
    }

    double averageBucketCount() {
        return (double)this.movingBucketCount / (double)this.size();
    }

    private int size() {
        if (this.latestBucketStartMs < 0L) {
            return 0;
        }
        return (int)((this.latestBucketStartMs - this.earliestBucketStartMs) / this.bucketSpanMs) + 1;
    }

    static interface BucketFlushListener {
        public void onBucketFlush(long var1, long var3);
    }
}

