/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class NodeLoad {
    private static final Logger logger = LogManager.getLogger(NodeLoadDetector.class);
    private final long maxMemory;
    private final int maxJobs;
    private final String nodeId;
    private final boolean useMemory;
    private final String error;
    private final int numAssignedAnomalyDetectorJobs;
    private final int numAssignedDataFrameAnalyticsJobs;
    private final int numAssignedNativeInferenceModels;
    private final long assignedNativeCodeOverheadMemory;
    private final long assignedAnomalyDetectorMemory;
    private final long assignedDataFrameAnalyticsMemory;
    private final long assignedNativeInferenceMemory;
    private final int numAllocatingJobs;

    NodeLoad(long maxMemory, int maxJobs, String nodeId, boolean useMemory, String error, int numAssignedAnomalyDetectorJobs, int numAssignedDataFrameAnalyticsJobs, int numAssignedNativeInferenceModels, long assignedNativeCodeOverheadMemory, long assignedAnomalyDetectorMemory, long assignedDataFrameAnalyticsMemory, long assignedNativeInferenceMemory, int numAllocatingJobs) {
        this.maxMemory = maxMemory;
        this.maxJobs = maxJobs;
        this.nodeId = nodeId;
        this.useMemory = useMemory;
        this.error = error;
        this.numAssignedAnomalyDetectorJobs = numAssignedAnomalyDetectorJobs;
        this.numAssignedDataFrameAnalyticsJobs = numAssignedDataFrameAnalyticsJobs;
        this.numAssignedNativeInferenceModels = numAssignedNativeInferenceModels;
        this.assignedNativeCodeOverheadMemory = assignedNativeCodeOverheadMemory;
        this.assignedAnomalyDetectorMemory = assignedAnomalyDetectorMemory;
        this.assignedDataFrameAnalyticsMemory = assignedDataFrameAnalyticsMemory;
        this.assignedNativeInferenceMemory = assignedNativeInferenceMemory;
        this.numAllocatingJobs = numAllocatingJobs;
    }

    public int getNumAssignedJobsAndModels() {
        return this.numAssignedAnomalyDetectorJobs + this.numAssignedDataFrameAnalyticsJobs + this.numAssignedNativeInferenceModels;
    }

    public long getAssignedJobMemory() {
        return this.assignedNativeCodeOverheadMemory + this.assignedAnomalyDetectorMemory + this.assignedDataFrameAnalyticsMemory + this.assignedNativeInferenceMemory;
    }

    public long getAssignedJobMemoryExcludingPerNodeOverhead() {
        return this.assignedAnomalyDetectorMemory + this.assignedDataFrameAnalyticsMemory + this.assignedNativeInferenceMemory;
    }

    public long getAssignedNativeCodeOverheadMemory() {
        return this.assignedNativeCodeOverheadMemory;
    }

    public long getAssignedAnomalyDetectorMemory() {
        return this.assignedAnomalyDetectorMemory;
    }

    public long getAssignedDataFrameAnalyticsMemory() {
        return this.assignedDataFrameAnalyticsMemory;
    }

    public long getAssignedNativeInferenceMemory() {
        return this.assignedNativeInferenceMemory;
    }

    public long getMaxMlMemory() {
        return this.maxMemory;
    }

    public int getMaxJobs() {
        return this.maxJobs;
    }

    public boolean isUseMemory() {
        return this.useMemory;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getFreeMemory() {
        return Math.max(this.maxMemory - this.getAssignedJobMemory(), 0L);
    }

    public long getFreeMemoryExcludingPerNodeOverhead() {
        return Math.max(this.maxMemory - this.getAssignedJobMemoryExcludingPerNodeOverhead() - MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), 0L);
    }

    public int remainingJobs() {
        return Math.max(this.maxJobs - (this.getNumAssignedJobsAndModels() - this.numAssignedNativeInferenceModels), 0);
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    public int getNumAllocatingJobs() {
        return this.numAllocatingJobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLoad nodeLoad = (NodeLoad)o;
        return this.maxMemory == nodeLoad.maxMemory && this.maxJobs == nodeLoad.maxJobs && this.useMemory == nodeLoad.useMemory && this.numAssignedAnomalyDetectorJobs == nodeLoad.numAssignedAnomalyDetectorJobs && this.numAssignedDataFrameAnalyticsJobs == nodeLoad.numAssignedDataFrameAnalyticsJobs && this.numAssignedNativeInferenceModels == nodeLoad.numAssignedNativeInferenceModels && this.assignedNativeCodeOverheadMemory == nodeLoad.assignedNativeCodeOverheadMemory && this.assignedAnomalyDetectorMemory == nodeLoad.assignedAnomalyDetectorMemory && this.assignedDataFrameAnalyticsMemory == nodeLoad.assignedDataFrameAnalyticsMemory && this.assignedNativeInferenceMemory == nodeLoad.assignedNativeInferenceMemory && this.numAllocatingJobs == nodeLoad.numAllocatingJobs && Objects.equals(this.nodeId, nodeLoad.nodeId) && Objects.equals(this.error, nodeLoad.error);
    }

    public int hashCode() {
        return Objects.hash(this.maxMemory, this.maxJobs, this.nodeId, this.useMemory, this.error, this.numAssignedAnomalyDetectorJobs, this.numAssignedDataFrameAnalyticsJobs, this.numAssignedNativeInferenceModels, this.assignedNativeCodeOverheadMemory, this.assignedAnomalyDetectorMemory, this.assignedDataFrameAnalyticsMemory, this.assignedNativeInferenceMemory, this.numAllocatingJobs);
    }

    public static Builder builder(String nodeId) {
        return new Builder(nodeId);
    }

    public static Builder builder(NodeLoad nodeLoad) {
        return new Builder(nodeLoad);
    }

    public static class Builder {
        private long maxMemory;
        private int maxJobs;
        private final String nodeId;
        private boolean useMemory;
        private String error;
        private int numAssignedAnomalyDetectorJobs;
        private int numAssignedDataFrameAnalyticsJobs;
        private int numAssignedNativeInferenceModels;
        private long assignedNativeCodeOverheadMemory;
        private long assignedAnomalyDetectorMemory;
        private long assignedDataFrameAnalyticsMemory;
        private long assignedNativeInferenceMemory;
        private int numAllocatingJobs;

        public Builder(NodeLoad nodeLoad) {
            this.maxMemory = nodeLoad.maxMemory;
            this.maxJobs = nodeLoad.maxJobs;
            this.nodeId = nodeLoad.nodeId;
            this.useMemory = nodeLoad.useMemory;
            this.error = nodeLoad.error;
            this.numAssignedAnomalyDetectorJobs = nodeLoad.numAssignedAnomalyDetectorJobs;
            this.numAssignedDataFrameAnalyticsJobs = nodeLoad.numAssignedDataFrameAnalyticsJobs;
            this.numAssignedNativeInferenceModels = nodeLoad.numAssignedNativeInferenceModels;
            this.assignedNativeCodeOverheadMemory = nodeLoad.assignedNativeCodeOverheadMemory;
            this.assignedAnomalyDetectorMemory = nodeLoad.assignedAnomalyDetectorMemory;
            this.assignedDataFrameAnalyticsMemory = nodeLoad.assignedDataFrameAnalyticsMemory;
            this.assignedNativeInferenceMemory = nodeLoad.assignedNativeInferenceMemory;
            this.numAllocatingJobs = nodeLoad.numAllocatingJobs;
        }

        public Builder(String nodeId) {
            this.nodeId = nodeId;
        }

        public long getFreeMemory() {
            return Math.max(this.maxMemory - this.assignedNativeCodeOverheadMemory - this.assignedAnomalyDetectorMemory - this.assignedDataFrameAnalyticsMemory - this.assignedNativeInferenceMemory, 0L);
        }

        public int remainingJobs() {
            return Math.max(this.maxJobs - (this.getNumAssignedJobs() - this.numAssignedNativeInferenceModels), 0);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public int getNumAssignedJobs() {
            return this.numAssignedAnomalyDetectorJobs + this.numAssignedDataFrameAnalyticsJobs + this.numAssignedNativeInferenceModels;
        }

        public Builder setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public Builder setMaxJobs(int maxJobs) {
            this.maxJobs = maxJobs;
            return this;
        }

        public Builder setUseMemory(boolean useMemory) {
            this.useMemory = useMemory;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder incNumAssignedAnomalyDetectorJobs() {
            ++this.numAssignedAnomalyDetectorJobs;
            return this;
        }

        public Builder incNumAssignedDataFrameAnalyticsJobs() {
            ++this.numAssignedDataFrameAnalyticsJobs;
            return this;
        }

        public Builder incNumAssignedNativeInferenceModels() {
            ++this.numAssignedNativeInferenceModels;
            return this;
        }

        public Builder incAssignedNativeCodeOverheadMemory(long assignedNativeCodeOverheadMemory) {
            this.assignedNativeCodeOverheadMemory += assignedNativeCodeOverheadMemory;
            return this;
        }

        public Builder incAssignedAnomalyDetectorMemory(long assignedAnomalyDetectorMemory) {
            this.assignedAnomalyDetectorMemory += assignedAnomalyDetectorMemory;
            return this;
        }

        public Builder incAssignedDataFrameAnalyticsMemory(long assignedDataFrameAnalyticsMemory) {
            this.assignedDataFrameAnalyticsMemory += assignedDataFrameAnalyticsMemory;
            return this;
        }

        public Builder incAssignedNativeInferenceMemory(long assignedNativeInferenceMemory) {
            this.assignedNativeInferenceMemory += assignedNativeInferenceMemory;
            return this;
        }

        public Builder incNumAllocatingJobs() {
            ++this.numAllocatingJobs;
            return this;
        }

        void addTask(String taskName, String taskId, boolean isAllocating, MlMemoryTracker memoryTracker) {
            Long jobMemoryRequirement;
            switch (taskName) {
                case "xpack/ml/job": 
                case "xpack/ml/job/snapshot/upgrade": {
                    this.incNumAssignedAnomalyDetectorJobs();
                    break;
                }
                case "xpack/ml/data_frame/analytics": {
                    this.incNumAssignedDataFrameAnalyticsJobs();
                    break;
                }
                default: {
                    assert (false) : "Unexpected task could not be accounted for: " + taskName;
                    break;
                }
            }
            if (isAllocating) {
                ++this.numAllocatingJobs;
            }
            if ((jobMemoryRequirement = memoryTracker.getJobMemoryRequirement(taskName, taskId)) == null) {
                this.useMemory = false;
                logger.debug("[{}] task memory requirement was not available.", (Object)taskId);
            } else {
                switch (taskName) {
                    case "xpack/ml/job": 
                    case "xpack/ml/job/snapshot/upgrade": {
                        this.assignedAnomalyDetectorMemory += jobMemoryRequirement.longValue();
                        break;
                    }
                    case "xpack/ml/data_frame/analytics": {
                        this.assignedDataFrameAnalyticsMemory += jobMemoryRequirement.longValue();
                        break;
                    }
                    default: {
                        assert (false) : "ML memory-requiring task name not handled: " + taskName;
                        this.assignedAnomalyDetectorMemory += jobMemoryRequirement.longValue();
                    }
                }
            }
        }

        public NodeLoad build() {
            return new NodeLoad(this.maxMemory, this.maxJobs, this.nodeId, this.useMemory, this.error, this.numAssignedAnomalyDetectorJobs, this.numAssignedDataFrameAnalyticsJobs, this.numAssignedNativeInferenceModels, this.assignedNativeCodeOverheadMemory, this.assignedAnomalyDetectorMemory, this.assignedDataFrameAnalyticsMemory, this.assignedNativeInferenceMemory, this.numAllocatingJobs);
        }
    }
}

