/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.adaptiveallocations;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;

class KalmanFilter1d {
    private static final Logger logger = LogManager.getLogger(KalmanFilter1d.class);
    private final String name;
    private final double smoothingFactor;
    private final boolean autodetectDynamicsChange;
    private double value;
    private double variance;
    private boolean dynamicsChangedLastTime;

    KalmanFilter1d(String name, double smoothingFactor, boolean autodetectDynamicsChange) {
        this.name = name;
        this.smoothingFactor = smoothingFactor;
        this.autodetectDynamicsChange = autodetectDynamicsChange;
        this.value = Double.MAX_VALUE;
        this.variance = Double.MAX_VALUE;
        this.dynamicsChangedLastTime = false;
    }

    void add(double value, double variance, boolean dynamicChangedExternal) {
        boolean dynamicChanged;
        if (!this.hasValue()) {
            dynamicChanged = true;
            this.value = value;
            this.variance = variance;
        } else {
            double processVariance = variance / this.smoothingFactor;
            boolean bl = dynamicChanged = dynamicChangedExternal || this.detectDynamicsChange(value, variance);
            if (dynamicChanged || this.dynamicsChangedLastTime) {
                processVariance = Math.pow(value, 2.0);
            }
            double gain = (this.variance + processVariance) / (this.variance + processVariance + variance);
            this.value += gain * (value - this.value);
            this.variance = (1.0 - gain) * (this.variance + processVariance);
        }
        this.dynamicsChangedLastTime = dynamicChanged;
        logger.debug(() -> Strings.format((String)"[%s] measurement %.3f \u00b1 %.3f: estimate %.3f \u00b1 %.3f (dynamic changed: %s).", (Object[])new Object[]{this.name, value, Math.sqrt(variance), this.value, Math.sqrt(this.variance), dynamicChanged}));
    }

    boolean hasValue() {
        return this.value < Double.MAX_VALUE && this.variance < Double.MAX_VALUE;
    }

    double estimate() {
        return this.value;
    }

    double error() {
        return Math.sqrt(this.variance);
    }

    double lower() {
        return this.value - this.error();
    }

    double upper() {
        return this.value + this.error();
    }

    private boolean detectDynamicsChange(double value, double variance) {
        return this.hasValue() && this.autodetectDynamicsChange && Math.pow(Math.abs(value - this.value), 2.0) / (variance + this.variance) > 100.0;
    }
}

