/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Strings;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.ml.dataframe.process.AbstractNativeAnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;

public class NativeAnalyticsProcess
extends AbstractNativeAnalyticsProcess<AnalyticsResult> {
    private static final Logger logger = LogManager.getLogger(NativeAnalyticsProcess.class);
    private static final String NAME = "analytics";
    private final AnalyticsProcessConfig config;

    protected NativeAnalyticsProcess(String jobId, NativeController nativeController, ProcessPipes processPipes, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash, AnalyticsProcessConfig config, NamedXContentRegistry namedXContentRegistry) {
        super(NAME, AnalyticsResult.PARSER, jobId, nativeController, processPipes, numberOfFields, filesToDelete, onProcessCrash, namedXContentRegistry);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AnalyticsProcessConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreState(Client client, String stateDocIdPrefix) throws IOException {
        Objects.requireNonNull(stateDocIdPrefix);
        try (OutputStream restoreStream = this.processRestoreStream();){
            int docNum = 0;
        }
    }

    private /* synthetic */ Object lambda$restoreState$0(SearchHit stateDoc) {
        return Strings.format((String)"[%s] Restoring state document [%s]", (Object[])new Object[]{this.config.jobId(), stateDoc.getId()});
    }
}

