/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorQueryContext;

public final class DataExtractorUtils {
    private static final String EPOCH_MILLIS = "epoch_millis";
    private static final String EARLIEST_TIME = "earliest_time";
    private static final String LATEST_TIME = "latest_time";

    private DataExtractorUtils() {
    }

    public static QueryBuilder wrapInTimeRangeQuery(QueryBuilder query, String timeField, long start, long end) {
        RangeQueryBuilder timeQuery = new RangeQueryBuilder(timeField).gte((Object)start).lt((Object)end).format(EPOCH_MILLIS);
        return new BoolQueryBuilder().filter(query).filter((QueryBuilder)timeQuery);
    }

    public static SearchRequestBuilder getSearchRequestBuilderForSummary(Client client, DataExtractorQueryContext context) {
        return new SearchRequestBuilder((ElasticsearchClient)client).setIndices(context.indices).setIndicesOptions(context.indicesOptions).setSource(DataExtractorUtils.getSearchSourceBuilderForSummary(context)).setAllowPartialSearchResults(false).setTrackTotalHits(true);
    }

    public static SearchSourceBuilder getSearchSourceBuilderForSummary(DataExtractorQueryContext context) {
        return new SearchSourceBuilder().size(0).query(DataExtractorUtils.wrapInTimeRangeQuery(context.query, context.timeField, context.start, context.end)).runtimeMappings(context.runtimeMappings).aggregation((AggregationBuilder)AggregationBuilders.min((String)EARLIEST_TIME).field(context.timeField)).aggregation((AggregationBuilder)AggregationBuilders.max((String)LATEST_TIME).field(context.timeField));
    }

    public static DataExtractor.DataSummary getDataSummary(SearchResponse searchResponse) {
        InternalAggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return new DataExtractor.DataSummary(null, null, 0L);
        }
        Long earliestTime = DataExtractorUtils.toLongIfFinite(((Min)aggregations.get(EARLIEST_TIME)).value());
        Long latestTime = DataExtractorUtils.toLongIfFinite(((Max)aggregations.get(LATEST_TIME)).value());
        long totalHits = searchResponse.getHits().getTotalHits().value();
        return new DataExtractor.DataSummary(earliestTime, latestTime, totalHits);
    }

    private static Long toLongIfFinite(double x) {
        return Double.isFinite(x) ? Long.valueOf((long)x) : null;
    }

    public static void checkForSkippedClusters(SearchResponse searchResponse) {
        SearchResponse.Clusters clusterResponse = searchResponse.getClusters();
        if (clusterResponse != null && clusterResponse.getClusterStateCount(SearchResponse.Cluster.Status.SKIPPED) > 0) {
            throw new ResourceNotFoundException("[{}] remote clusters out of [{}] were skipped when performing datafeed search", new Object[]{clusterResponse.getClusterStateCount(SearchResponse.Cluster.Status.SKIPPED), clusterResponse.getTotal()});
        }
    }
}

