/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public abstract class AbstractItemSetMapReducer<MapContext extends Closeable, MapFinalContext extends Writeable, ReduceContext extends Closeable, Result extends ToXContent & Writeable>
implements NamedWriteable {
    private final String aggregationName;
    private final String mapReducerName;

    protected AbstractItemSetMapReducer(String aggregationName, String mapReducerName) {
        this.aggregationName = aggregationName;
        this.mapReducerName = mapReducerName;
    }

    protected OrdinalOptimization getDefaultOrdinalOptimization() {
        return OrdinalOptimization.NO_ORDINALS;
    }

    protected abstract MapContext mapInit(BigArrays var1);

    protected abstract MapContext map(Stream<Tuple<ItemSetMapReduceValueSource.Field, List<Object>>> var1, MapContext var2);

    protected MapContext mapFiltered(MapContext mapContext) {
        return mapContext;
    }

    protected abstract MapFinalContext mapFinalize(MapContext var1, List<OrdinalLookupFunction> var2) throws IOException;

    protected abstract ReduceContext reduceInit(BigArrays var1);

    protected abstract ReduceContext reduce(Stream<MapFinalContext> var1, ReduceContext var2, Supplier<Boolean> var3);

    protected abstract MapFinalContext combine(Stream<MapFinalContext> var1, ReduceContext var2, Supplier<Boolean> var3);

    protected abstract Result reduceFinalize(ReduceContext var1, List<ItemSetMapReduceValueSource.Field> var2, Supplier<Boolean> var3) throws IOException;

    protected Result finalizeSampling(SamplingContext samplingContext, Result result) {
        return result;
    }

    protected abstract MapFinalContext readMapReduceContext(StreamInput var1, BigArrays var2) throws IOException;

    protected abstract Result readResult(StreamInput var1, BigArrays var2) throws IOException;

    protected void collectDebugInfo(BiConsumer<String, Object> add) {
    }

    final boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    public final String getWriteableName() {
        return this.aggregationName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.mapReducerName);
    }

    public static enum OrdinalOptimization {
        NO_ORDINALS,
        GLOBAL_ORDINALS;

    }

    public static interface OrdinalLookupFunction
    extends CheckedFunction<Object, Object, IOException> {
    }
}

