/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.correlation;

import java.util.Map;
import java.util.stream.LongStream;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.correlation.CorrelationFunction;
import org.elasticsearch.xpack.ml.aggs.correlation.CountCorrelationIndicator;

public class BucketCorrelationAggregator
extends SiblingPipelineAggregator {
    private final CorrelationFunction correlationFunction;

    public BucketCorrelationAggregator(String name, CorrelationFunction correlationFunction, String bucketsPath, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
        this.correlationFunction = correlationFunction;
    }

    public InternalAggregation doReduce(InternalAggregations aggregations, AggregationReduceContext context) {
        CountCorrelationIndicator bucketPathValue = MlAggsHelper.extractDoubleBucketedValues(this.bucketsPaths()[0], aggregations).map(doubleBucketValues -> new CountCorrelationIndicator(doubleBucketValues.getValues(), null, LongStream.of(doubleBucketValues.getDocCounts()).sum())).orElse(null);
        if (bucketPathValue == null) {
            throw new IllegalArgumentException("unable to find valid bucket values in path [" + this.bucketsPaths()[0] + "] for agg [" + this.name() + "]");
        }
        return new InternalSimpleValue(this.name(), this.correlationFunction.execute(bucketPathValue), DocValueFormat.RAW, this.metadata());
    }
}

