/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;

public class MlConfigMigrationEligibilityCheck {
    public static final Setting<Boolean> ENABLE_CONFIG_MIGRATION = Setting.boolSetting((String)"xpack.ml.enable_config_migration", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private volatile boolean isConfigMigrationEnabled;

    public MlConfigMigrationEligibilityCheck(Settings settings, ClusterService clusterService) {
        this.isConfigMigrationEnabled = (Boolean)ENABLE_CONFIG_MIGRATION.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLE_CONFIG_MIGRATION, this::setConfigMigrationEnabled);
    }

    private void setConfigMigrationEnabled(boolean configMigrationEnabled) {
        this.isConfigMigrationEnabled = configMigrationEnabled;
    }

    public boolean canStartMigration(ClusterState clusterState) {
        if (!this.isConfigMigrationEnabled) {
            return false;
        }
        return MlConfigMigrationEligibilityCheck.mlConfigIndexIsAllocated(clusterState);
    }

    static boolean mlConfigIndexIsAllocated(ClusterState clusterState) {
        IndexAbstraction configIndexOrAlias = (IndexAbstraction)clusterState.metadata().getProject().getIndicesLookup().get(MlConfigIndex.indexName());
        if (configIndexOrAlias == null) {
            return false;
        }
        IndexRoutingTable routingTable = clusterState.getRoutingTable().index(configIndexOrAlias.getWriteIndex());
        return routingTable != null && routingTable.allPrimaryShardsActive() && routingTable.readyForSearch();
    }
}

