/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PostSecretRequest
extends LegacyActionRequest {
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<PostSecretRequest, Void> PARSER = new ConstructingObjectParser("post_secret_request", args -> new PostSecretRequest((String)args[0]));
    private final String value;

    public static PostSecretRequest fromXContent(XContentParser parser) throws IOException {
        return (PostSecretRequest)((Object)PARSER.parse(parser, null));
    }

    public PostSecretRequest(String value) {
        this.value = value;
    }

    public PostSecretRequest(StreamInput in) throws IOException {
        super(in);
        this.value = in.readString();
    }

    public String value() {
        return this.value;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.value);
    }

    public ActionRequestValidationException validate() {
        if (this.value == null) {
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("value is missing");
            return exception;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PostSecretRequest that = (PostSecretRequest)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), VALUE_FIELD, ObjectParser.ValueType.STRING);
    }
}

