/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class VoyageAIRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "voyageai_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_K_DOCS_ONLY = "top_k";
    public static final VoyageAIRerankTaskSettings EMPTY_SETTINGS = new VoyageAIRerankTaskSettings(null, null, null);
    private static final TransportVersion VOYAGE_AI_INTEGRATION_ADDED = TransportVersion.fromName((String)"voyage_ai_integration_added");
    private final Integer topKDocumentsOnly;
    private final Boolean returnDocuments;
    private final Boolean truncation;

    public static VoyageAIRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topKDocumentsOnly = ServiceUtils.extractOptionalPositiveInteger(map, TOP_K_DOCS_ONLY, "task_settings", validationException);
        Boolean truncation = ServiceUtils.extractOptionalBoolean(map, "truncation", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return VoyageAIRerankTaskSettings.of(topKDocumentsOnly, returnDocuments, truncation);
    }

    public static VoyageAIRerankTaskSettings of(VoyageAIRerankTaskSettings originalSettings, VoyageAIRerankTaskSettings requestTaskSettings) {
        return new VoyageAIRerankTaskSettings(requestTaskSettings.getTopKDocumentsOnly() != null ? requestTaskSettings.getTopKDocumentsOnly() : originalSettings.getTopKDocumentsOnly(), requestTaskSettings.getReturnDocuments() != null ? requestTaskSettings.getReturnDocuments() : originalSettings.getReturnDocuments(), requestTaskSettings.getTruncation() != null ? requestTaskSettings.getTruncation() : originalSettings.getTruncation());
    }

    public static VoyageAIRerankTaskSettings of(Integer topKDocumentsOnly, Boolean returnDocuments, Boolean truncation) {
        return new VoyageAIRerankTaskSettings(topKDocumentsOnly, returnDocuments, truncation);
    }

    public VoyageAIRerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalInt(), in.readOptionalBoolean(), in.readOptionalBoolean());
    }

    public VoyageAIRerankTaskSettings(@Nullable Integer topKDocumentsOnly, @Nullable Boolean doReturnDocuments, @Nullable Boolean truncation) {
        this.topKDocumentsOnly = topKDocumentsOnly;
        this.returnDocuments = doReturnDocuments;
        this.truncation = truncation;
    }

    public boolean isEmpty() {
        return this.topKDocumentsOnly == null && this.returnDocuments == null && this.truncation == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topKDocumentsOnly != null) {
            builder.field(TOP_K_DOCS_ONLY, this.topKDocumentsOnly);
        }
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        if (this.truncation != null) {
            builder.field("truncation", this.truncation);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return VOYAGE_AI_INTEGRATION_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(VOYAGE_AI_INTEGRATION_ADDED);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.topKDocumentsOnly);
        out.writeOptionalBoolean(this.returnDocuments);
        out.writeOptionalBoolean(this.truncation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoyageAIRerankTaskSettings that = (VoyageAIRerankTaskSettings)o;
        return Objects.equals(this.topKDocumentsOnly, that.topKDocumentsOnly) && Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.truncation, that.truncation);
    }

    public int hashCode() {
        return Objects.hash(this.truncation, this.returnDocuments, this.topKDocumentsOnly);
    }

    public Integer getTopKDocumentsOnly() {
        return this.topKDocumentsOnly;
    }

    public Boolean getDoesReturnDocuments() {
        return this.returnDocuments;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public Boolean getTruncation() {
        return this.truncation;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        VoyageAIRerankTaskSettings updatedSettings = VoyageAIRerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return VoyageAIRerankTaskSettings.of(this, updatedSettings);
    }
}

