/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.validation;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.validation.ServiceIntegrationValidator;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.inference.services.validation.ModelValidator;

public class TextEmbeddingModelValidator
implements ModelValidator {
    private final ServiceIntegrationValidator serviceIntegrationValidator;

    public TextEmbeddingModelValidator(ServiceIntegrationValidator serviceIntegrationValidator) {
        this.serviceIntegrationValidator = serviceIntegrationValidator;
    }

    @Override
    public void validate(InferenceService service, Model model, TimeValue timeout, ActionListener<Model> listener) {
        this.serviceIntegrationValidator.validate(service, model, timeout, listener.delegateFailureAndWrap((delegate, r) -> delegate.onResponse((Object)this.postValidate(service, model, (InferenceServiceResults)r))));
    }

    private Model postValidate(InferenceService service, Model model, InferenceServiceResults results) {
        if (results instanceof TextEmbeddingResults) {
            TextEmbeddingResults embeddingResults = (TextEmbeddingResults)results;
            ServiceSettings serviceSettings = model.getServiceSettings();
            Integer dimensions = serviceSettings.dimensions();
            int embeddingSize = this.getEmbeddingSize(embeddingResults);
            if (Boolean.TRUE.equals(serviceSettings.dimensionsSetByUser()) && dimensions != null && !dimensions.equals(embeddingSize)) {
                throw new ElasticsearchStatusException(Strings.format((String)"The retrieved embeddings size [%s] does not match the size specified in the settings [%s]. Please recreate the [%s] configuration with the correct dimensions", (Object[])new Object[]{embeddingResults.getFirstEmbeddingSize(), serviceSettings.dimensions(), model.getInferenceEntityId()}), RestStatus.BAD_REQUEST, new Object[0]);
            }
            return service.updateModelWithEmbeddingDetails(model, embeddingSize);
        }
        throw new ElasticsearchStatusException("Validation call did not return expected results type.Expected a result of type [text_embedding_service_results] got [" + (results == null ? "null" : results.getWriteableName()) + "]", RestStatus.BAD_REQUEST, new Object[0]);
    }

    private int getEmbeddingSize(TextEmbeddingResults<?> embeddingResults) {
        int embeddingSize;
        try {
            embeddingSize = embeddingResults.getFirstEmbeddingSize();
        }
        catch (Exception e) {
            throw new ElasticsearchStatusException("Could not determine embedding size", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
        return embeddingSize;
    }
}

